/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.brewery;

import de.melanx.utilitix.recipe.BreweryRecipe;
import de.melanx.utilitix.recipe.PotionOutput;
import de.melanx.utilitix.registration.ModItemTags;
import de.melanx.utilitix.registration.ModItems;
import de.melanx.utilitix.registration.ModRecipeTypes;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.moddingx.libx.base.tile.BlockEntityBase;
import org.moddingx.libx.base.tile.TickingBlock;
import org.moddingx.libx.crafting.RecipeHelper;
import org.moddingx.libx.inventory.BaseItemStackHandler;
import org.moddingx.libx.inventory.FilterItemHandler;

public class AdvancedBreweryBlockEntity
extends BlockEntityBase
implements TickingBlock {
    public static final int MAX_BREW_TIME = 400;
    public static final int INGREDIENT_SLOT = 0;
    public static final int POTION_SLOT_RIGHT = 1;
    public static final int POTION_SLOT_LEFT = 2;
    public static final int OUTPUT_SLOT = 3;
    public static final int FUEL_SLOT = 4;
    private int brewTime = 0;
    private int fuel = 0;
    private final BaseItemStackHandler inventory = BaseItemStackHandler.builder((int)5).contentsChanged(slot -> {
        this.setChanged();
        this.setDispatchable();
    }).validator(stack -> this.level != null && RecipeHelper.isItemValidInput((RecipeManager)this.level.getRecipeManager(), ModRecipeTypes.BREWERY, (ItemStack)stack), new int[]{0}).validator(stack -> stack.is(ModItemTags.BOTTLES), new int[]{1, 2, 3}).validator(stack -> stack.getItem() == Items.BLAZE_POWDER, new int[]{4}).slotLimit(1, new int[]{1, 2, 3}).build();
    private final RecipeWrapper recipeInput = new RecipeWrapper((IItemHandler)this.inventory);
    public final IItemHandler inventoryTop = new FilterItemHandler((IItemHandler)this.inventory, slot -> false, (slot, stack) -> slot == 0 || slot == 3);
    public final IItemHandler inventorySide = new FilterItemHandler((IItemHandler)this.inventory, slot -> false, (slot, stack) -> slot == 1 || slot == 2 || slot == 4);
    public final IItemHandler inventoryBottom = new FilterItemHandler((IItemHandler)this.inventory, slot -> slot == 3 || slot == 1 || slot == 2, (slot, stack) -> false);

    public AdvancedBreweryBlockEntity(BlockEntityType<?> blockEntityTypeIn, BlockPos pos, BlockState state) {
        super(blockEntityTypeIn, pos, state);
    }

    public void tick() {
        ItemStack fuelStack;
        if (this.level == null || this.level.isClientSide) {
            this.clientTick();
            return;
        }
        if (this.fuel <= 0 && (fuelStack = this.inventory.getStackInSlot(4)).getItem() == Items.BLAZE_POWDER && !fuelStack.isEmpty()) {
            this.fuel = 20;
            ItemStack fuelNew = fuelStack.copy();
            fuelNew.shrink(1);
            this.inventory.setStackInSlot(4, fuelNew);
            this.setChanged();
            this.setDispatchable();
        }
        Optional recipe = this.level.getRecipeManager().getRecipeFor(ModRecipeTypes.BREWERY, (RecipeInput)this.recipeInput, this.level);
        if ((this.fuel <= 0 || recipe.isEmpty()) && this.brewTime > 0) {
            this.brewTime = 0;
            this.setChanged();
            this.setDispatchable();
            return;
        }
        if (recipe.isEmpty() || this.fuel < 0) {
            return;
        }
        if (this.brewTime <= 0) {
            this.setDispatchable();
        }
        this.brewTime = Mth.clamp((int)(this.brewTime + 1), (int)0, (int)400);
        if (this.brewTime < 400) {
            this.setChanged();
            return;
        }
        PotionOutput output = ((BreweryRecipe)((RecipeHolder)recipe.get()).value()).getPotionResult(this.recipeInput);
        if (output == null || output.getMain().isEmpty()) {
            this.consumeItem(3);
        } else {
            this.inventory.setStackInSlot(3, output.getMain());
        }
        this.consumeItem(0);
        if (output == null || output.getOut1().isEmpty()) {
            this.consumeItem(1);
        } else {
            this.inventory.setStackInSlot(1, output.getOut1());
        }
        if (output == null || output.getOut2().isEmpty()) {
            this.consumeItem(2);
        } else {
            this.inventory.setStackInSlot(2, output.getOut2());
        }
        this.brewTime = 0;
        --this.fuel;
        this.level.playSound(null, this.worldPosition, SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS);
        this.setDispatchable();
        this.setChanged();
    }

    private void clientTick() {
        if (this.brewTime <= 0 || this.brewTime >= 400) {
            return;
        }
        ++this.brewTime;
        if (this.level == null || this.level.getGameTime() % 4L != 0L || this.brewTime >= 370) {
            return;
        }
        double xf = 0.5;
        double zf = 0.15;
        Direction dir = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (dir.getAxis() == Direction.Axis.X) {
            double tmp = xf;
            xf = zf;
            zf = tmp;
        }
        if (dir.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
            xf = 1.0 - xf;
            zf = 1.0 - zf;
        }
        this.level.addParticle((ParticleOptions)ParticleTypes.DRIPPING_WATER, (double)this.worldPosition.getX() + xf, (double)this.worldPosition.getY() + 0.34, (double)this.worldPosition.getZ() + zf, 0.0, -0.6, 0.0);
    }

    private void consumeItem(int slot) {
        ItemStack stack = this.inventory.getStackInSlot(slot);
        if (stack.isEmpty()) {
            return;
        }
        if (stack.hasCraftingRemainingItem()) {
            this.inventory.setStackInSlot(slot, stack.getCraftingRemainingItem().copy());
            return;
        }
        if (stack.getItem() == Items.POTION || stack.getItem() == ModItems.failedPotion) {
            this.inventory.setStackInSlot(slot, new ItemStack((ItemLike)Items.GLASS_BOTTLE, stack.getCount()));
            return;
        }
        if (stack.getCount() <= 1) {
            this.inventory.setStackInSlot(slot, ItemStack.EMPTY);
            return;
        }
        ItemStack copy = stack.copy();
        copy.shrink(1);
        this.inventory.setStackInSlot(slot, copy);
    }

    public static IItemHandler getCapability(AdvancedBreweryBlockEntity be, Direction side) {
        if (side == null) {
            return be.getInventory();
        }
        return switch (side) {
            case Direction.DOWN -> be.inventoryBottom;
            case Direction.UP -> be.inventoryTop;
            default -> be.inventorySide;
        };
    }

    @Nonnull
    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    @Nonnull
    public IItemHandlerModifiable getUnrestricted() {
        return this.inventory.getUnrestricted();
    }

    public int getBrewTime() {
        return this.brewTime;
    }

    public int getFuel() {
        return this.fuel;
    }

    protected void loadAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("Inventory"));
        this.brewTime = tag.getInt("brewTime");
        this.fuel = tag.getInt("fuel");
    }

    protected void saveAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        tag.putInt("brewTime", this.brewTime);
        tag.putInt("fuel", this.fuel);
    }

    public void handleUpdateTag(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider lookupProvider) {
        if (this.level != null && this.level.isClientSide) {
            super.handleUpdateTag(tag, lookupProvider);
            this.inventory.deserializeNBT(lookupProvider, tag.getCompound("Inventory"));
            this.brewTime = tag.getInt("brewTime");
            this.fuel = tag.getInt("fuel");
        }
    }

    @Nonnull
    public CompoundTag getUpdateTag(@Nonnull HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        if (this.level != null && !this.level.isClientSide) {
            tag.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
            tag.putInt("brewTime", this.brewTime);
            tag.putInt("fuel", this.fuel);
        }
        return tag;
    }
}

