/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.compat.jei;

import com.google.common.collect.ImmutableList;
import de.melanx.utilitix.compat.jei.BreweryCategory;
import de.melanx.utilitix.compat.jei.CrudeSmeltingCategory;
import de.melanx.utilitix.compat.jei.GildingCategory;
import de.melanx.utilitix.content.brewery.AdvancedBreweryMenu;
import de.melanx.utilitix.content.brewery.AdvancedBreweryScreen;
import de.melanx.utilitix.content.crudefurnace.CrudeFurnaceMenu;
import de.melanx.utilitix.content.crudefurnace.CrudeFurnaceRecipeHelper;
import de.melanx.utilitix.content.crudefurnace.CrudeFurnaceScreen;
import de.melanx.utilitix.content.gildingarmor.GildingArmorRecipe;
import de.melanx.utilitix.recipe.BreweryRecipe;
import de.melanx.utilitix.recipe.brewery.Apply;
import de.melanx.utilitix.registration.ModBlocks;
import de.melanx.utilitix.registration.ModDataComponentTypes;
import de.melanx.utilitix.registration.ModItems;
import de.melanx.utilitix.registration.ModRecipeTypes;
import de.melanx.utilitix.registration.ModRegisterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.compress.utils.Lists;

@JeiPlugin
public class UtiliJei
implements IModPlugin {
    private static IJeiRuntime runtime = null;
    public static final RecipeType<BreweryRecipe> BREWING_RECIPE = RecipeType.create((String)"utilitix", (String)"advanced_brewery", BreweryRecipe.class);
    public static final RecipeType<SmithingTransformRecipe> GILDING_RECIPE = RecipeType.create((String)"utilitix", (String)"gilding", SmithingTransformRecipe.class);
    public static final RecipeType<SmeltingRecipe> SMELTING_RECIPE = RecipeType.create((String)"utilitix", (String)"smelting", SmeltingRecipe.class);

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"utilitix", (String)"jeiplugin");
    }

    public void registerCategories(@Nonnull IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new BreweryCategory(registration.getJeiHelpers().getGuiHelper()), new GildingCategory(registration.getJeiHelpers().getGuiHelper()), new CrudeSmeltingCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        ClientLevel level = Minecraft.getInstance().level;
        RecipeManager recipes = Objects.requireNonNull(level).getRecipeManager();
        List simpleBrewery = recipes.getAllRecipesFor(ModRecipeTypes.BREWERY).stream().filter(r -> ((BreweryRecipe)r.value()).getAction() instanceof Apply).map(RecipeHolder::value).collect(Collectors.toList());
        registration.addRecipes(BREWING_RECIPE, simpleBrewery);
        registration.addRecipes(GILDING_RECIPE, UtiliJei.getGildingRecipes());
        registration.addRecipes(SMELTING_RECIPE, UtiliJei.getSmeltingRecipes(recipes, level.registryAccess()));
        registration.addIngredientInfo(ModBlocks.advancedBrewery, new Component[]{Component.translatable((String)"description.utilitix.advanced_brewery")});
        registration.addIngredientInfo(ModBlocks.advancedBrewery, new Component[]{Component.translatable((String)"description.utilitix.advanced_brewery.brewing")});
        registration.addIngredientInfo(ModBlocks.advancedBrewery, new Component[]{Component.translatable((String)"description.utilitix.advanced_brewery.merging")});
        registration.addIngredientInfo(ModBlocks.advancedBrewery, new Component[]{Component.translatable((String)"description.utilitix.advanced_brewery.upgrading")});
        registration.addIngredientInfo(ModBlocks.advancedBrewery, new Component[]{Component.translatable((String)"description.utilitix.advanced_brewery.cloning")});
        registration.addItemStackInfo((List)ImmutableList.of((Object)new ItemStack((ItemLike)ModBlocks.comparatorRedirectorUp), (Object)new ItemStack((ItemLike)ModBlocks.comparatorRedirectorDown)), new Component[]{Component.translatable((String)"description.utilitix.comparator_redirector")});
        registration.addIngredientInfo((ItemLike)ModBlocks.weakRedstoneTorch, new Component[]{Component.translatable((String)"description.utilitix.weak_redstone_torch")});
        registration.addItemStackInfo((List)ImmutableList.of((Object)new ItemStack((ItemLike)ModItems.tinyCoal), (Object)new ItemStack((ItemLike)ModItems.tinyCharcoal)), new Component[]{Component.translatable((String)"description.utilitix.tiny_coal")});
        registration.addIngredientInfo((ItemLike)ModItems.handBell, new Component[]{Component.translatable((String)"description.utilitix.hand_bell")});
        registration.addIngredientInfo((ItemLike)ModItems.mobBell, new Component[]{Component.translatable((String)"description.utilitix.mob_bell")});
        registration.addIngredientInfo((ItemLike)ModItems.failedPotion, new Component[]{Component.translatable((String)"description.utilitix.failed_potion")});
        registration.addIngredientInfo((ItemLike)ModItems.armedStand, new Component[]{Component.translatable((String)"description.utilitix.armed_stand")});
        registration.addIngredientInfo((ItemLike)ModItems.glueBall, new Component[]{Component.translatable((String)"description.utilitix.glue_ball")});
        registration.addIngredientInfo((ItemLike)ModItems.linkedCrystal, new Component[]{Component.translatable((String)"description.utilitix.linked_crystal")});
        registration.addIngredientInfo((ItemLike)ModBlocks.linkedRepeater, new Component[]{Component.translatable((String)"description.utilitix.linked_repeater")});
        registration.addIngredientInfo((ItemLike)ModItems.minecartTinkerer, new Component[]{Component.translatable((String)"description.utilitix.minecart_tinkerer")});
        registration.addIngredientInfo((ItemLike)ModBlocks.highspeedRail, new Component[]{Component.translatable((String)"description.utilitix.highspeed_rail")});
        registration.addItemStackInfo((List)ImmutableList.of((Object)new ItemStack((ItemLike)ModBlocks.directionalRail), (Object)new ItemStack((ItemLike)ModBlocks.directionalHighspeedRail)), new Component[]{Component.translatable((String)"description.utilitix.directional_rail")});
        registration.addItemStackInfo((List)ImmutableList.of((Object)new ItemStack((ItemLike)ModBlocks.crossingRail), (Object)new ItemStack((ItemLike)ModBlocks.reinforcedCrossingRail)), new Component[]{Component.translatable((String)"description.utilitix.crossing_rail")});
        registration.addItemStackInfo((List)ImmutableList.of((Object)new ItemStack((ItemLike)ModBlocks.filterRail), (Object)new ItemStack((ItemLike)ModBlocks.reinforcedFilterRail)), new Component[]{Component.translatable((String)"description.utilitix.filter_rail")});
        registration.addIngredientInfo((ItemLike)ModBlocks.reinforcedRail, new Component[]{Component.translatable((String)"description.utilitix.reinforced_rail")});
        registration.addIngredientInfo((ItemLike)ModRegisterables.enderCart.item(), new Component[]{Component.translatable((String)"description.utilitix.ender_cart")});
        registration.addIngredientInfo((ItemLike)ModRegisterables.pistonCart.item(), new Component[]{Component.translatable((String)"description.utilitix.piston_cart")});
        registration.addItemStackInfo((List)ImmutableList.of((Object)new ItemStack((ItemLike)ModBlocks.pistonControllerRail), (Object)new ItemStack((ItemLike)ModBlocks.reinforcedPistonControllerRail)), new Component[]{Component.translatable((String)"description.utilitix.piston_controller_rail")});
        registration.addIngredientInfo((ItemLike)ModRegisterables.stonecutterCart.item(), new Component[]{Component.translatable((String)"description.utilitix.stonecutter_cart")});
        registration.addIngredientInfo((ItemLike)ModRegisterables.anvilCart.item(), new Component[]{Component.translatable((String)"description.utilitix.anvil_cart")});
        registration.addIngredientInfo(ModBlocks.crudeFurnace, new Component[]{Component.translatable((String)"description.utilitix.crude_furnace")});
        registration.addIngredientInfo((ItemLike)ModItems.mobYoinker, new Component[]{Component.translatable((String)"description.utilitix.mob_yoinker")});
    }

    public void registerRecipeTransferHandlers(@Nonnull IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(CrudeFurnaceMenu.class, (MenuType)ModBlocks.crudeFurnace.menu, RecipeTypes.FUELING, 0, 1, 3, 36);
        registration.addRecipeTransferHandler(CrudeFurnaceMenu.class, (MenuType)ModBlocks.crudeFurnace.menu, SMELTING_RECIPE, 1, 1, 3, 36);
        registration.addRecipeTransferHandler(AdvancedBreweryMenu.class, (MenuType)ModBlocks.advancedBrewery.menu, BREWING_RECIPE, 0, 4, 5, 36);
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack(ModBlocks.advancedBrewery), new RecipeType[]{BREWING_RECIPE});
        registration.addRecipeCatalyst(new ItemStack(ModBlocks.crudeFurnace), new RecipeType[]{SMELTING_RECIPE, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.SMITHING_TABLE), new RecipeType[]{GILDING_RECIPE});
    }

    public void registerGuiHandlers(@Nonnull IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(AdvancedBreweryScreen.class, 98, 17, 7, 26, new RecipeType[]{BREWING_RECIPE});
        registration.addRecipeClickArea(CrudeFurnaceScreen.class, 78, 32, 28, 23, new RecipeType[]{SMELTING_RECIPE, RecipeTypes.FUELING});
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        runtime = jeiRuntime;
    }

    public static void runtime(Consumer<IJeiRuntime> action) {
        if (runtime != null) {
            action.accept(runtime);
        }
    }

    public static <T> Optional<T> runtime(Function<IJeiRuntime, T> action) {
        if (runtime != null) {
            return Optional.of(action.apply(runtime));
        }
        return Optional.empty();
    }

    private static List<SmithingTransformRecipe> getGildingRecipes() {
        ArrayList recipes = Lists.newArrayList();
        Ingredient gildingItem = Ingredient.of((ItemLike[])new ItemLike[]{ModItems.gildingCrystal});
        for (Map.Entry entry : BuiltInRegistries.ITEM.entrySet()) {
            ArmorItem item;
            Object v = entry.getValue();
            if (!(v instanceof ArmorItem) || !GildingArmorRecipe.canGild(item = (ArmorItem)v, new ItemStack((ItemLike)item))) continue;
            ItemStack output = new ItemStack((ItemLike)item);
            output.set(ModDataComponentTypes.gilded, (Object)true);
            SmithingTransformRecipe recipe = new SmithingTransformRecipe(Ingredient.EMPTY, Ingredient.of((ItemLike[])new ItemLike[]{item}), gildingItem, output);
            recipes.add(recipe);
        }
        return Collections.unmodifiableList(recipes);
    }

    private static List<SmeltingRecipe> getSmeltingRecipes(RecipeManager recipes, RegistryAccess registryAccess) {
        Registry items = registryAccess.registryOrThrow(Registries.ITEM);
        ArrayList<SmeltingRecipe> crudingRecipes = new ArrayList<SmeltingRecipe>();
        for (Item item : items) {
            CrudeFurnaceRecipeHelper.ModifiedRecipe result = CrudeFurnaceRecipeHelper.getResult(recipes, registryAccess, new ItemStack((ItemLike)item));
            if (result == null) continue;
            crudingRecipes.add((SmeltingRecipe)result.getRecipeHolder().value());
        }
        return crudingRecipes;
    }
}

