/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.compat.jei;

import de.melanx.utilitix.compat.jei.UtiliJei;
import de.melanx.utilitix.registration.ModBlocks;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import org.jetbrains.annotations.Nullable;

public class CrudeSmeltingCategory
implements IRecipeCategory<SmeltingRecipe> {
    private static final int DEFAULT_COOK_TIME = 100;
    private final IDrawable icon;

    public CrudeSmeltingCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(ModBlocks.crudeFurnace));
    }

    @Nonnull
    public RecipeType<SmeltingRecipe> getRecipeType() {
        return UtiliJei.SMELTING_RECIPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.translatable((String)"jei.utilitix.cruding");
    }

    public int getWidth() {
        return 82;
    }

    public int getHeight() {
        return 54;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull SmeltingRecipe recipe, @Nonnull IFocusGroup focuses) {
        builder.addInputSlot(1, 1).setStandardSlotBackground().addIngredients((Ingredient)recipe.getIngredients().getFirst());
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 1, 37).setStandardSlotBackground();
        builder.addOutputSlot(61, 19).setOutputSlotBackground().addItemStack(RecipeUtil.getResultItem((Recipe)recipe));
    }

    public void createRecipeExtras(@Nonnull IRecipeExtrasBuilder builder, SmeltingRecipe recipe, @Nonnull IFocusGroup focuses) {
        int cookTime = recipe.getCookingTime() / 2;
        if (cookTime <= 0) {
            cookTime = 100;
        }
        builder.addAnimatedRecipeArrow(cookTime).setPosition(26, 17);
        builder.addAnimatedRecipeFlame(300).setPosition(1, 20);
        this.addExperience(builder, recipe);
        this.addCookTime(builder, recipe);
    }

    protected void addExperience(IRecipeExtrasBuilder builder, SmeltingRecipe recipe) {
        float experience = recipe.getExperience();
        if (experience > 0.0f) {
            MutableComponent experienceString = Component.translatable((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            ((ITextWidget)builder.addText((FormattedText)experienceString, this.getWidth() - 20, 10).setPosition(0, 0, this.getWidth(), this.getHeight(), HorizontalAlignment.RIGHT, VerticalAlignment.TOP)).setTextAlignment(HorizontalAlignment.RIGHT).setColor(-8355712);
        }
    }

    protected void addCookTime(IRecipeExtrasBuilder builder, SmeltingRecipe recipe) {
        int cookTime = recipe.getCookingTime() / 2;
        if (cookTime <= 0) {
            cookTime = 100;
        }
        int cookTimeSeconds = cookTime / 20;
        MutableComponent timeString = Component.translatable((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
        ((ITextWidget)builder.addText((FormattedText)timeString, this.getWidth() - 20, 10).setPosition(0, 0, this.getWidth(), this.getHeight(), HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM)).setTextAlignment(HorizontalAlignment.RIGHT).setTextAlignment(VerticalAlignment.BOTTOM).setColor(-8355712);
    }
}

