/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.compat.jade;

import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.compat.jade.UtilJade;
import de.melanx.utilitix.content.experiencecrystal.ExperienceCrystalBlockEntity;
import de.melanx.utilitix.util.XPUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.ElementHelper;

public class ExperienceCrystalProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public static final ResourceLocation UID = UtilitiX.getInstance().resource("experience_crystal");
    public static final ExperienceCrystalProvider INSTANCE = new ExperienceCrystalProvider();
    private static final ItemStack XP_BOTTLE = new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE);

    public ResourceLocation getUid() {
        return UID;
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (!config.get(UtilJade.EXPERIENCE_CRYSTAL)) {
            return;
        }
        int xp = accessor.getServerData().getInt("Xp");
        IElementHelper helper = IElementHelper.get();
        tooltip.add(helper.smallItem(XP_BOTTLE));
        if (accessor.getServerData().getBoolean("ShowDetails")) {
            tooltip.append(helper.text((Component)Component.translatable((String)"jade.utilitix.experience_crystal.xp")).translate(ElementHelper.SMALL_ITEM_OFFSET));
            tooltip.append(helper.text((Component)Component.literal((String)String.valueOf(xp))).translate(ElementHelper.SMALL_ITEM_OFFSET));
        } else {
            tooltip.append(helper.text((Component)Component.translatable((String)"jade.utilitix.experience_crystal.level")).translate(ElementHelper.SMALL_ITEM_OFFSET));
            tooltip.append(helper.text((Component)Component.literal((String)((Integer)XPUtils.getLevelExp(xp).getLeft()).toString())).translate(ElementHelper.SMALL_ITEM_OFFSET));
        }
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        ExperienceCrystalBlockEntity crystal = (ExperienceCrystalBlockEntity)accessor.getBlockEntity();
        data.putInt("Xp", crystal.getXp());
        data.putBoolean("ShowDetails", accessor.showDetails());
    }
}

