/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix;

import de.melanx.utilitix.config.CommonConfig;
import de.melanx.utilitix.content.MobYoinkerItem;
import de.melanx.utilitix.content.brewery.AdvancedBreweryBlockEntity;
import de.melanx.utilitix.content.crudefurnace.CrudeFurnaceBlockEntity;
import de.melanx.utilitix.content.experiencecrystal.ExperienceCrystalBlockEntity;
import de.melanx.utilitix.registration.ModBlocks;
import de.melanx.utilitix.registration.ModItems;
import de.melanx.utilitix.util.MobUtil;
import de.melanx.utilitix.util.XPUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="utilitix")
public class EventListener {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity;
        Player player = event.getEntity();
        if (!player.isShiftKeyDown() || !((entity = event.getTarget()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        InteractionHand hand = event.getHand();
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() == ModItems.mobBell) {
            if (MobUtil.storeEntityData(player, hand, target, CommonConfig.HandBells.mobBellEntities, true)) {
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
            return;
        }
        if (stack.getItem() == ModItems.mobYoinker) {
            if (!player.isCreative()) {
                int health;
                int diff;
                int xp = player.experienceLevel;
                if (CommonConfig.MobYoinker.experienceMode == MobYoinkerItem.ExperienceMode.POINTS) {
                    xp = XPUtils.getExpPoints(player.experienceLevel, player.experienceProgress);
                }
                if ((diff = xp - (health = (int)target.getHealth())) < 0) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.utilitix.mob_yoinker", (Object[])new Object[]{-diff, CommonConfig.MobYoinker.experienceMode == MobYoinkerItem.ExperienceMode.LEVEL ? Component.translatable((String)"levels") : Component.translatable((String)"points")}), true);
                    return;
                }
            }
            if (MobUtil.storeEntityData(player, hand, target, CommonConfig.MobYoinker.mobYoinkerEntities, false)) {
                if (CommonConfig.MobYoinker.experienceMode == MobYoinkerItem.ExperienceMode.LEVEL) {
                    player.giveExperienceLevels((int)(-target.getHealth()));
                } else {
                    player.giveExperiencePoints((int)(-target.getHealth()));
                }
                target.remove(Entity.RemovalReason.DISCARDED);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlocks.advancedBrewery.getBlockEntityType(), AdvancedBreweryBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlocks.crudeFurnace.getBlockEntityType(), CrudeFurnaceBlockEntity::getCapability);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, ModBlocks.experienceCrystal.getBlockEntityType(), ExperienceCrystalBlockEntity::getCapability);
    }
}

