/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.mixin;

import de.melanx.utilitix.registration.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={World.class})
public class MixinWorld {
    @Redirect(method={"getRedstonePowerFromNeighbors(Lnet/minecraft/util/math/BlockPos;)I"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getRedstonePower(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/Direction;)I"))
    public int getRedstonePowerAsCallFromNeighbours(World world, BlockPos pos, Direction facing) {
        int power = 0;
        BlockState state = world.func_180495_p(pos);
        if (state.func_185911_a((IBlockReader)world, pos, facing) > 0) {
            power = world.func_175651_c(pos, facing);
        }
        if (state.shouldCheckWeakPower((IWorldReader)world, pos, facing)) {
            power = Math.max(power, this.getNearStrongPower(world, pos));
        }
        return power;
    }

    public int getNearStrongPower(World world, BlockPos pos) {
        BlockPos posDown = pos.func_177977_b();
        Block block = world.func_180495_p(posDown).func_177230_c();
        if (block == ModBlocks.weakRedstoneTorch || block == ModBlocks.weakRedstoneTorch.wallTorch) {
            int power = world.func_175627_a(pos.func_177984_a(), Direction.UP);
            if (power >= 15) {
                return power;
            }
            if ((power = Math.max(power, world.func_175627_a(pos.func_177978_c(), Direction.NORTH))) >= 15) {
                return power;
            }
            if ((power = Math.max(power, world.func_175627_a(pos.func_177968_d(), Direction.SOUTH))) >= 15) {
                return power;
            }
            if ((power = Math.max(power, world.func_175627_a(pos.func_177976_e(), Direction.WEST))) >= 15) {
                return power;
            }
            return (power = Math.max(power, world.func_175627_a(pos.func_177974_f(), Direction.EAST))) >= 15 ? power : power;
        }
        return world.func_175676_y(pos);
    }
}

