/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.item.bells;

import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.item.bells.BellBase;
import de.melanx.utilitix.item.bells.RenderHandBell;
import io.github.noeppi_noeppi.libx.mod.ModX;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class MobBell
extends BellBase {
    private static final IFormattableTextComponent NO_MOB = new TranslationTextComponent("tooltip." + UtilitiX.getInstance().modid + ".no_mob").func_240699_a_(TextFormatting.DARK_RED);

    public MobBell(ModX mod, Item.Properties properties) {
        super(mod, properties.setISTER(() -> RenderHandBell::new));
    }

    @Override
    protected boolean entityFilter(LivingEntity entity, ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        if (!stack.func_196082_o().func_74764_b("Entity")) {
            return false;
        }
        String s = stack.func_196082_o().func_74779_i("Entity");
        return EntityType.func_200718_a((EntityType)entity.func_200600_R()).equals((Object)ResourceLocation.func_208304_a((String)s));
    }

    @Override
    protected boolean notifyNearbyEntities() {
        return false;
    }

    @Override
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        IFormattableTextComponent component = MobBell.getCurrentMob(stack);
        tooltip.add((ITextComponent)(component != null ? component : NO_MOB));
    }

    @Nullable
    public static IFormattableTextComponent getCurrentMob(ItemStack stack) {
        String s = stack.func_196082_o().func_74779_i("Entity");
        Optional entityType = EntityType.func_220327_a((String)s);
        return entityType.map(MobBell::getCurrentMob).orElse(null);
    }

    @Nonnull
    public static IFormattableTextComponent getCurrentMob(EntityType<?> entityType) {
        ITextComponent name = entityType.func_212546_e();
        TranslationTextComponent component = new TranslationTextComponent("tooltip." + UtilitiX.getInstance().modid + ".current_mob");
        component.func_240699_a_(entityType.func_220339_d() == EntityClassification.MONSTER ? TextFormatting.RED : TextFormatting.GOLD);
        return component.func_240702_b_(": ").func_230529_a_(name);
    }

    public static int getColor(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("Entity", 8)) {
            SpawnEggItem egg;
            ResourceLocation rl = ResourceLocation.func_208304_a((String)stack.func_77978_p().func_74779_i("Entity"));
            EntityType entityType = rl == null ? null : (EntityType)ForgeRegistries.ENTITIES.getValue(rl);
            SpawnEggItem spawnEggItem = egg = entityType == null ? null : SpawnEggItem.func_200889_b((EntityType)entityType);
            if (egg != null) {
                return Objects.requireNonNull(egg).func_195983_a(0);
            }
        }
        return 0xFFFFFF;
    }

    public static float[] getFloatColor(ItemStack stack) {
        int color = MobBell.getColor(stack);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new float[]{r, g, b};
    }
}

