/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.toolswap.helper;

import de.melanx.toolswap.config.ClientConfig;
import de.melanx.toolswap.helper.ToolEntry;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;

public class Util {
    private static final MutableComponent WARNING = Component.translatable((String)"toolswap.warning").withStyle(ChatFormatting.DARK_RED);

    public static boolean validItem(ItemStack item) {
        return item.has(DataComponents.TOOL) && Util.hasEnoughDurability(item);
    }

    public static boolean shouldIgnore(ItemStack heldItem) {
        boolean bl;
        block7: {
            block6: {
                switch ((ClientConfig.IgnoreMode)((Object)ClientConfig.ignoreEmptyHand.get())) {
                    case EMPTY_HAND: {
                        if (!heldItem.isEmpty()) break;
                        break block6;
                    }
                    case ITEMS: {
                        if (heldItem.isEmpty()) break;
                        break block6;
                    }
                    case TOOLS: {
                        if (!heldItem.has(DataComponents.TOOL)) break;
                        break block6;
                    }
                    case NO_TOOLS: {
                        if (heldItem.has(DataComponents.TOOL)) break;
                        break block6;
                    }
                    default: {
                        break block6;
                    }
                }
                bl = true;
                break block7;
            }
            bl = false;
        }
        return bl;
    }

    public static void saveItem(LocalPlayer player) {
        ItemStack equalTool;
        if (Util.hasEnoughDurability(player.getMainHandItem())) {
            return;
        }
        MultiPlayerGameMode controller = Minecraft.getInstance().gameMode;
        AbstractContainerMenu container = player.containerMenu;
        int emptySlot = -1;
        ItemStack currentTool = player.getInventory().getItem(player.getInventory().getSelectedSlot());
        if (currentTool != (equalTool = Util.findEqualTool(player.getInventory(), currentTool))) {
            emptySlot = player.getInventory().findSlotMatchingItem(equalTool);
        }
        if (emptySlot == -1) {
            for (Slot slot : container.slots) {
                if (slot.index <= 9 || !slot.getItem().isEmpty()) continue;
                emptySlot = slot.index;
                break;
            }
        }
        if (emptySlot != -1) {
            controller.handleInventoryMouseClick(container.containerId, player.getInventory().getSelectedSlot() + 36, 0, ClickType.PICKUP, (Player)player);
            controller.handleInventoryMouseClick(container.containerId, emptySlot, 0, ClickType.PICKUP, (Player)player);
            controller.handleInventoryMouseClick(container.containerId, player.getInventory().getSelectedSlot() + 36, 0, ClickType.PICKUP, (Player)player);
        } else {
            player.displayClientMessage((Component)WARNING, true);
        }
    }

    public static void sortTools(List<ToolEntry> tools) {
        Comparator<ToolEntry> comparator;
        switch ((ClientConfig.SortType)((Object)ClientConfig.sortType.get())) {
            case LEVEL: {
                Comparator<ToolEntry> comparator2 = Comparator.comparing(ToolEntry::damagePerBlock);
                break;
            }
            case LEVEL_INVERTED: {
                Comparator<ToolEntry> comparator2 = Comparator.comparing(ToolEntry::damagePerBlock).reversed();
                break;
            }
            case ENCHANTED_FIRST: {
                Comparator<ToolEntry> comparator2 = Comparator.comparing(ToolEntry::isEnchanted).reversed().thenComparing(ToolEntry::damagePerBlock);
                break;
            }
            case ENCHANTED_LAST: {
                Comparator<ToolEntry> comparator2 = Comparator.comparing(ToolEntry::isEnchanted).thenComparing(ToolEntry::damagePerBlock);
                break;
            }
            default: {
                Comparator<ToolEntry> comparator2 = comparator = null;
            }
        }
        if (comparator == null) {
            if (ClientConfig.sortType.get() == ClientConfig.SortType.RIGHT_TO_LEFT) {
                Collections.reverse(tools);
            }
            return;
        }
        tools.sort(comparator);
    }

    private static boolean hasEnoughDurability(ItemStack stack) {
        return (Boolean)ClientConfig.saveBreakingTools.get() == false || !stack.isDamageableItem() || stack.getDamageValue() != stack.getMaxDamage() - (Integer)ClientConfig.minDurability.get();
    }

    private static ItemStack findEqualTool(Inventory inventory, ItemStack stack) {
        if (stack.has(DataComponents.TOOL)) {
            Tool tool = (Tool)stack.get(DataComponents.TOOL);
            List rules = tool.rules();
            for (ItemStack item : inventory.getNonEquipmentItems()) {
                if (!Util.validItem(item) || ((Tool)item.get(DataComponents.TOOL)).rules() != rules) continue;
                return item;
            }
        }
        return stack;
    }
}

