/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.toolswap.handler;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.neoforged.fml.loading.FMLPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToggleState {
    private static final Path SWAP_STATE_FILE = FMLPaths.CONFIGDIR.get().resolve(".toolswap");
    private static final Logger LOGGER = LoggerFactory.getLogger(ToggleState.class);
    private static ToggleState INSTANCE;
    private boolean shouldSwapTools = false;

    private ToggleState() {
        this.load();
    }

    public static ToggleState initialize() {
        if (INSTANCE == null) {
            INSTANCE = new ToggleState();
        }
        return INSTANCE;
    }

    private void load() {
        try {
            if (Files.notExists(SWAP_STATE_FILE, new LinkOption[0])) {
                Files.writeString(SWAP_STATE_FILE, (CharSequence)"true", new OpenOption[0]);
                this.shouldSwapTools = true;
                return;
            }
            String s = Files.readString(SWAP_STATE_FILE);
            this.shouldSwapTools = Boolean.parseBoolean(s);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to load swap state", (Throwable)e);
        }
    }

    public void save() {
        try {
            Files.writeString(SWAP_STATE_FILE, (CharSequence)String.valueOf(this.shouldSwapTools), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to save swap state", (Throwable)e);
        }
    }

    public void toggleConfig() {
        this.shouldSwapTools = !this.shouldSwapTools;
    }

    public boolean shouldSwapTools() {
        return this.shouldSwapTools;
    }
}

