/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.toolswap.handler;

import de.melanx.toolswap.SwapKeys;
import de.melanx.toolswap.ToolSwap;
import de.melanx.toolswap.config.ClientConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ToggleKeyMapping;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHandler {
    private static EventHandler INSTANCE;
    private static final Logger LOGGER;

    private EventHandler(IEventBus modBus, IEventBus neoforgeBus) {
        neoforgeBus.addListener(this::leftClickBlock);
        neoforgeBus.addListener(this::onClientTick);
        neoforgeBus.addListener(this::onPlayerTick);
        neoforgeBus.addListener(this::onOpenScreen);
        modBus.addListener(this::onKeyRegistration);
    }

    public static void initialize(IEventBus modBus, IEventBus neoforgeBus) {
        if (INSTANCE == null) {
            INSTANCE = new EventHandler(modBus, neoforgeBus);
        }
    }

    private void onKeyRegistration(RegisterKeyMappingsEvent event) {
        event.registerCategory(SwapKeys.TOOLSWAP_KEYS);
        event.register((KeyMapping)SwapKeys.TOGGLE.get());
    }

    private void leftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getAction() == PlayerInteractEvent.LeftClickBlock.Action.START || ((Boolean)ClientConfig.oneBlockMode.get()).booleanValue()) {
            ToolSwap.getInstance().searchForSwitching(event.getLevel(), event.getEntity(), event.getPos());
        }
    }

    private void onClientTick(ClientTickEvent.Post event) {
        while (((ToggleKeyMapping)SwapKeys.TOGGLE.get()).consumeClick()) {
            ToolSwap.getInstance().getToggleState().toggleConfig();
            boolean shouldSwapTools = ToolSwap.getInstance().getToggleState().shouldSwapTools();
            MutableComponent state = Component.translatable((String)("toolswap.key.toggle_toolswap_notification.state_" + (shouldSwapTools ? "on" : "off"))).withStyle(Style.EMPTY.applyFormat(shouldSwapTools ? ChatFormatting.GREEN : ChatFormatting.DARK_RED));
            MutableComponent statusMessage = Component.translatable((String)"toolswap.key.toggle_toolswap_notification", (Object[])new Object[]{shouldSwapTools});
            statusMessage.append(": ").append((Component)state);
            if (Minecraft.getInstance().player != null) {
                Minecraft.getInstance().player.displayClientMessage((Component)statusMessage, true);
            }
            LOGGER.debug("Set tool swap mode to {}", (Object)shouldSwapTools);
        }
    }

    private void onPlayerTick(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        if (player instanceof LocalPlayer) {
            LocalPlayer player2 = (LocalPlayer)player;
            if (ToolSwap.getInstance().getToggleHandler().getSlot() != -1 && !Minecraft.getInstance().options.keyAttack.isDown()) {
                ToolSwap.getInstance().getToggleHandler().resetSlot(player2);
            }
        }
    }

    private void onOpenScreen(ScreenEvent.Opening event) {
        if (event.getScreen() instanceof PauseScreen) {
            ToolSwap.getInstance().getToggleState().save();
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(EventHandler.class);
    }
}

