/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.ultimatools.util;

import com.google.common.collect.ImmutableList;
import de.melanx.ultimatools.lib.Function5;
import de.melanx.ultimatools.lib.ListHandlers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.EventHooks;
import org.apache.commons.compress.utils.Lists;

public class ToolEffects {
    private static final Random RANDOM = new Random();

    private ToolEffects() {
    }

    public static boolean placeWater(Level level, Player player, InteractionHand hand, BlockPos pos, Direction face) {
        BlockPos target = pos.relative(face);
        if (!level.getBlockState(target).canBeReplaced((Fluid)Fluids.WATER) && !level.getBlockState(target).hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            return false;
        }
        if (!player.mayUseItemAt(pos, face, player.getItemInHand(hand))) {
            return false;
        }
        if (!level.getBlockState(target).hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            level.destroyBlock(target, true);
            level.setBlockAndUpdate(target, Fluids.WATER.defaultFluidState().createLegacyBlock());
        } else {
            level.setBlockAndUpdate(target, (BlockState)level.getBlockState(target).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        }
        return true;
    }

    public static boolean spawnAnimal(Level level, Player player, InteractionHand hand, BlockPos pos, Direction face) {
        BlockPos target = pos.relative(face);
        if (level.getBlockState(target).canOcclude()) {
            return false;
        }
        if (!player.mayUseItemAt(pos, face, player.getItemInHand(hand))) {
            return false;
        }
        EntityType<?> entityType = level.getBlockState(target).getFluidState().getType() == Fluids.WATER || level.getBlockState(target).getFluidState().getType() == Fluids.FLOWING_WATER ? ListHandlers.WATER_ANIMALS.get(level.random.nextInt(ListHandlers.WATER_ANIMALS.size())) : ListHandlers.ANIMALS.get(level.random.nextInt(ListHandlers.ANIMALS.size()));
        Mob entity = (Mob)entityType.create(level, EntitySpawnReason.TRIGGERED);
        if (entity == null) {
            return false;
        }
        entity.snapTo((double)target.getX() + 0.5, (double)target.getY() + 0.1, (double)target.getZ() + 0.5, player.getYHeadRot() - 180.0f, 0.0f);
        if (level instanceof ServerLevel) {
            EventHooks.finalizeMobSpawn((Mob)entity, (ServerLevelAccessor)((ServerLevelAccessor)level), (DifficultyInstance)level.getCurrentDifficultyAt(target), (EntitySpawnReason)EntitySpawnReason.TRIGGERED, null);
        }
        if (entity instanceof Animal) {
            ((Animal)entity).setAge(-24000);
        }
        level.addFreshEntity((Entity)entity);
        return true;
    }

    public static boolean applyMagicDamage(LivingEntity target, Player player) {
        if (target.isAlive()) {
            target.hurt(player.level().damageSources().indirectMagic((Entity)player, null), 60.0f);
            return true;
        }
        return false;
    }

    public static boolean useBonemeal(Level level, Player player, InteractionHand hand, BlockPos pos, Direction face) {
        if (!player.mayUseItemAt(pos, face, player.getItemInHand(hand))) {
            return false;
        }
        return BoneMealItem.applyBonemeal((ItemStack)new ItemStack((ItemLike)Items.BONE_MEAL), (Level)level, (BlockPos)pos, (Player)player);
    }

    public static boolean upgradeOre(Level level, Player player, InteractionHand hand, BlockPos pos, Direction face) {
        if (!player.mayUseItemAt(pos, face, player.getItemInHand(hand))) {
            return false;
        }
        Block block = level.getBlockState(pos).getBlock();
        ImmutableList ORES = ImmutableList.copyOf(ListHandlers.ORES);
        for (int i = 0; i < ORES.size() - 1; ++i) {
            if (block != ORES.get(i)) continue;
            BlockState newState = ((Block)ORES.get(i + 1)).defaultBlockState();
            SoundType sound = block.getSoundType(newState, (LevelReader)level, pos, (Entity)player);
            level.playSound(null, pos, sound.getPlaceSound(), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 2.0f, sound.getPitch() * 0.8f);
            level.setBlockAndUpdate(pos, newState);
            return true;
        }
        ImmutableList ORES_NETHER = ImmutableList.copyOf(ListHandlers.NETHER_ORES);
        for (int i = 0; i < ORES_NETHER.size() - 1; ++i) {
            if (block != ORES_NETHER.get(i)) continue;
            BlockState newState = ((Block)ORES_NETHER.get(i + 1)).defaultBlockState();
            SoundType sound = block.getSoundType(newState, (LevelReader)level, pos, (Entity)player);
            level.playSound(null, pos, sound.getPlaceSound(), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 2.0f, sound.getPitch() * 0.8f);
            level.setBlockAndUpdate(pos, newState);
            return true;
        }
        return false;
    }

    public static Function5<Level, Player, InteractionHand, BlockPos, Direction, Boolean> changeBlock(Block from, Block to) {
        return ToolEffects.changeBlock(Collections.singleton(from), to.defaultBlockState());
    }

    public static Function5<Level, Player, InteractionHand, BlockPos, Direction, Boolean> changeBlock(Block from, BlockState to) {
        return ToolEffects.changeBlock(Collections.singleton(from), to);
    }

    public static Function5<Level, Player, InteractionHand, BlockPos, Direction, Boolean> changeBlock(Set<Block> from, Block to) {
        return ToolEffects.changeBlock(from, to.defaultBlockState());
    }

    public static Function5<Level, Player, InteractionHand, BlockPos, Direction, Boolean> changeBlock(Set<Block> from, BlockState to) {
        return ToolEffects.changeBlock(from::contains, to);
    }

    public static Function5<Level, Player, InteractionHand, BlockPos, Direction, Boolean> changeBlock(TagKey<Block> from, Block to) {
        return ToolEffects.changeBlock(from, to.defaultBlockState());
    }

    public static Function5<Level, Player, InteractionHand, BlockPos, Direction, Boolean> changeBlock(TagKey<Block> from, BlockState to) {
        Predicate<Block> predicate = block -> {
            for (Holder holder : BuiltInRegistries.BLOCK.getTagOrEmpty(from)) {
                if (block != holder.value()) continue;
                return true;
            }
            return false;
        };
        return ToolEffects.changeBlock(predicate, to);
    }

    public static Function5<Level, Player, InteractionHand, BlockPos, Direction, Boolean> changeBlock(Predicate<Block> from, Block to) {
        return ToolEffects.changeBlock(from, to.defaultBlockState());
    }

    public static Function5<Level, Player, InteractionHand, BlockPos, Direction, Boolean> changeBlock(Predicate<Block> from, BlockState to) {
        return (level, player, hand, pos, face) -> {
            if (!player.mayUseItemAt(pos, face, player.getItemInHand(hand))) {
                return false;
            }
            if (!from.test(level.getBlockState(pos).getBlock())) {
                return false;
            }
            SoundType sound = to.getBlock().getSoundType(to, (LevelReader)level, pos, (Entity)player);
            level.playSound(null, pos, sound.getPlaceSound(), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 2.0f, sound.getPitch() * 0.8f);
            level.setBlockAndUpdate(pos, to);
            return true;
        };
    }

    public static boolean applyPotion(LivingEntity target, Player player) {
        if (target.isAlive()) {
            switch (player.level().random.nextInt(5)) {
                case 0: {
                    target.hurt(player.level().damageSources().indirectMagic((Entity)player, null), 10.0f);
                    break;
                }
                case 1: {
                    target.addEffect(new MobEffectInstance(MobEffects.POISON, 600));
                    break;
                }
                case 2: {
                    target.addEffect(new MobEffectInstance(MobEffects.WITHER, 600));
                    break;
                }
                case 3: {
                    target.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 600));
                    break;
                }
                default: {
                    target.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 600, 3));
                }
            }
            return true;
        }
        return false;
    }

    public static boolean generateOre(Level level, Player player, InteractionHand hand, BlockPos pos, Direction face) {
        if (!player.mayUseItemAt(pos, face, player.getItemInHand(hand))) {
            return false;
        }
        if (level.getBlockState(pos).is(Tags.Blocks.COBBLESTONES) || level.getBlockState(pos).is(Tags.Blocks.STONES)) {
            Block block = ToolEffects.getRandomBlock((TagKey<Block>)Tags.Blocks.ORES);
            BlockState state = block.defaultBlockState();
            SoundType sound = block.getSoundType(state, (LevelReader)level, pos, (Entity)player);
            level.playSound(null, pos, sound.getPlaceSound(), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 2.0f, sound.getPitch() * 0.8f);
            level.setBlockAndUpdate(pos, state);
            return true;
        }
        return false;
    }

    public static boolean ultimate(Level level, Player player, InteractionHand hand, BlockPos pos, Direction face) {
        BlockState block = level.getBlockState(pos);
        if (!block.is(BlockTags.DIRT) && !block.is(Blocks.GRASS_BLOCK) && !(block.getBlock() instanceof BonemealableBlock) && player.isShiftKeyDown()) {
            return ToolEffects.placeWater(level, player, hand, pos, face);
        }
        if (!player.isShiftKeyDown()) {
            if (block.is(BlockTags.DIRT)) {
                BlockState newState = Blocks.GRASS_BLOCK.defaultBlockState();
                SoundType sound = block.getSoundType((LevelReader)level, pos, (Entity)player);
                level.playSound(null, pos, sound.getPlaceSound(), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 2.0f, sound.getPitch() * 0.8f);
                level.setBlockAndUpdate(pos, newState);
                return true;
            }
            if (block.is(Tags.Blocks.COBBLESTONES) || block.is(Tags.Blocks.STONES)) {
                return ToolEffects.generateOre(level, player, hand, pos, face);
            }
        } else {
            if (block.is(BlockTags.DIRT) || block.is(Blocks.GRASS_BLOCK) || level.getBlockState(pos.relative(face)).getBlock() == Blocks.WATER) {
                return ToolEffects.spawnAnimal(level, player, hand, pos, face);
            }
            return ToolEffects.useBonemeal(level, player, hand, pos, face);
        }
        return false;
    }

    public static boolean applyRegeneration(Level level, Player player, InteractionHand hand) {
        player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 1));
        return true;
    }

    public static boolean applyLevitation(Level level, Player player, InteractionHand hand) {
        player.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 40, 9));
        return true;
    }

    public static boolean removeFluid(Level level, Player player, InteractionHand hand, BlockPos pos, Direction face) {
        ItemStack stack;
        BlockPos target;
        BlockState state;
        if (player.mayUseItemAt(pos, face, player.getItemInHand(hand)) && (state = level.getBlockState(target = pos.relative(face))).getBlock() instanceof BucketPickup && !(stack = ((BucketPickup)state.getBlock()).pickupBlock((LivingEntity)player, (LevelAccessor)level, target, state)).isEmpty() && stack.getItem() != Items.BUCKET) {
            player.playSound(stack.getItem() == Items.LAVA_BUCKET ? SoundEvents.BUCKET_FILL_LAVA : SoundEvents.BUCKET_FILL, 1.0f, 1.0f);
            for (int x = 0; x < 5; ++x) {
                level.addParticle((ParticleOptions)ParticleTypes.POOF, (double)pos.getX() + level.random.nextDouble(), (double)pos.getY() + level.random.nextDouble(), (double)pos.getZ() + level.random.nextDouble(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        return false;
    }

    private static Block getRandomBlock(TagKey<Block> key) {
        ArrayList blocks = Lists.newArrayList();
        for (Holder holder : BuiltInRegistries.BLOCK.getTagOrEmpty(key)) {
            blocks.add((Block)holder.value());
        }
        return (Block)blocks.get(RANDOM.nextInt(blocks.size()));
    }
}

