/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.ultimatools.lib;

import de.melanx.ultimatools.ServerConfig;
import de.melanx.ultimatools.SkyblockUltimaTools;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ListHandlers {
    public static final List<Block> ORES = new ArrayList<Block>();
    public static final List<Block> NETHER_ORES = new ArrayList<Block>();
    public static final List<EntityType<?>> ANIMALS = new ArrayList();
    public static final List<EntityType<?>> WATER_ANIMALS = new ArrayList();

    public static void fillOres() {
        ORES.clear();
        ((List)ServerConfig.OVERWORLD_ORES.get()).forEach(string -> {
            Block block = (Block)BuiltInRegistries.BLOCK.getValue(Identifier.tryParse((String)string));
            if (block != Blocks.AIR) {
                ORES.add(block);
            } else {
                SkyblockUltimaTools.LOGGER.error("Block '{}' not found", string);
            }
        });
    }

    public static void fillNetherOres() {
        NETHER_ORES.clear();
        ((List)ServerConfig.NETHER_ORES.get()).forEach(string -> {
            Block block = (Block)BuiltInRegistries.BLOCK.getValue(Identifier.tryParse((String)string));
            if (block != Blocks.AIR) {
                NETHER_ORES.add(block);
            } else {
                SkyblockUltimaTools.LOGGER.error("Block '{}' not found", string);
            }
        });
    }

    public static void fillAnimals() {
        ANIMALS.clear();
        ((List)ServerConfig.ANIMALS.get()).forEach(string -> {
            EntityType entity = (EntityType)BuiltInRegistries.ENTITY_TYPE.getValue(Identifier.tryParse((String)string));
            if (entity != null) {
                if (entity.getCategory() == MobCategory.CREATURE || entity.getCategory() == MobCategory.AMBIENT) {
                    if (BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity).toString().equals(string)) {
                        ANIMALS.add(entity);
                    } else {
                        SkyblockUltimaTools.LOGGER.error("Entity '{}' not found", string);
                    }
                } else {
                    SkyblockUltimaTools.LOGGER.error("'{}' is no animal", string);
                }
            }
        });
    }

    public static void fillWaterAnimals() {
        WATER_ANIMALS.clear();
        ((List)ServerConfig.WATER_ANIMALS.get()).forEach(string -> {
            EntityType entity = (EntityType)BuiltInRegistries.ENTITY_TYPE.getValue(Identifier.tryParse((String)string));
            if (entity != null) {
                if (entity.getCategory() == MobCategory.WATER_CREATURE || entity.getCategory() == MobCategory.WATER_AMBIENT) {
                    if (BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity).toString().equals(string)) {
                        WATER_ANIMALS.add(entity);
                    } else {
                        SkyblockUltimaTools.LOGGER.error("Entity '{}' not found", string);
                    }
                } else {
                    SkyblockUltimaTools.LOGGER.error("'{}' is no water animal", string);
                }
            }
        });
    }

    public static void reloadLists() {
        ListHandlers.fillOres();
        ListHandlers.fillNetherOres();
        ListHandlers.fillAnimals();
        ListHandlers.fillWaterAnimals();
    }
}

