/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.ultimatools;

import de.melanx.ultimatools.ServerConfig;
import de.melanx.ultimatools.item.Registration;
import de.melanx.ultimatools.lib.ListHandlers;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="ultimatools")
public class SkyblockUltimaTools {
    public static final String MODID = "ultimatools";
    public static final Logger LOGGER = LogManager.getLogger((String)"ultimatools");

    public SkyblockUltimaTools(Dist dist, IEventBus bus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)ServerConfig.SERVER_CONFIG);
        Registration.init(bus);
        bus.addListener(this::onServerStarted);
        bus.addListener(this::onConfigChange);
        bus.addListener(this::creativeModTab);
        if (dist.isClient()) {
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
    }

    private void creativeModTab(RegisterEvent event) {
        event.register(Registries.CREATIVE_MODE_TAB, helper -> helper.register(Identifier.fromNamespaceAndPath((String)MODID, (String)"tab"), (Object)CreativeModeTab.builder().title((Component)Component.literal((String)"Skyblock Ultima Tools")).icon(() -> new ItemStack((ItemLike)Registration.ultimaGod.get())).displayItems((params, output) -> {
            for (DeferredHolder entry : Registration.ITEMS.getEntries()) {
                output.accept((ItemLike)entry.get());
            }
        }).build()));
    }

    private void onServerStarted(FMLCommonSetupEvent event) {
        ListHandlers.reloadLists();
    }

    private void onConfigChange(ModConfigEvent event) {
        if (event.getConfig().getModId().equals(MODID)) {
            ListHandlers.reloadLists();
        }
    }
}

