/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.world.chunkgenerators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.melanx.skyblockbuilder.config.common.StructuresConfig;
import de.melanx.skyblockbuilder.config.common.WorldConfig;
import de.melanx.skyblockbuilder.world.flat.FlatLayerConfig;
import de.melanx.skyblockbuilder.world.flat.FlatLayers;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;

public class SkyblockNoiseBasedChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final MapCodec<SkyblockNoiseBasedChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeSource.CODEC.fieldOf("biome_source").forGetter(generator -> generator.biomeSource), (App)NoiseGeneratorSettings.CODEC.fieldOf("settings").forGetter(generator -> generator.generatorSettings), (App)Level.RESOURCE_KEY_CODEC.fieldOf("dimension").forGetter(generator -> generator.dimension), (App)FlatLayers.CODEC.optionalFieldOf("layers", (Object)FlatLayers.EMPTY).forGetter(generator -> generator.flatLayers)).apply((Applicative)instance, instance.stable(SkyblockNoiseBasedChunkGenerator::new)));
    public final Holder<NoiseGeneratorSettings> generatorSettings;
    public final ResourceKey<Level> dimension;
    protected final NoiseBasedChunkGenerator parent;
    protected final FlatLayers flatLayers;
    private final int layerHeight;

    public SkyblockNoiseBasedChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> generatorSettings, ResourceKey<Level> dimension, FlatLayers flatLayers) {
        super(biomeSource, generatorSettings);
        this.generatorSettings = generatorSettings;
        this.parent = new NoiseBasedChunkGenerator(biomeSource, generatorSettings);
        this.dimension = dimension;
        this.flatLayers = flatLayers;
        this.layerHeight = this.flatLayers.totalHeight();
    }

    @Nonnull
    protected MapCodec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    public int getSeaLevel() {
        return WorldConfig.seaHeight;
    }

    public void buildSurface(@Nonnull WorldGenRegion level, @Nonnull StructureManager structureManager, @Nonnull RandomState randomState, @Nonnull ChunkAccess chunk) {
        if (!this.flatLayers.isEmpty()) {
            ChunkPos cp = chunk.getPos();
            int xs = cp.getMinBlockX();
            int zs = cp.getMinBlockZ();
            int xe = cp.getMaxBlockX();
            int ze = cp.getMaxBlockZ();
            int y = level.getMinBuildHeight();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (FlatLayerConfig info : this.flatLayers.layers()) {
                BlockState state = info.getBlockState();
                for (int i = 0; i < info.getHeight(); ++i) {
                    for (int x = xs; x <= xe; ++x) {
                        for (int z = zs; z <= ze; ++z) {
                            if (info.hasExtra()) {
                                if (!info.checkChance(level.getRandom())) {
                                    state = info.getBlockState();
                                } else {
                                    Optional maybeBlock = info.getExtraBlocks().getRandom(level.getRandom());
                                    if (maybeBlock.isPresent()) {
                                        state = ((FlatLayerConfig.WeightedBlockEntry)maybeBlock.get()).block().defaultBlockState();
                                    }
                                }
                            }
                            pos.setX(x);
                            pos.setY(y);
                            pos.setZ(z);
                            chunk.setBlockState((BlockPos)pos, state, false);
                        }
                    }
                    ++y;
                }
            }
        }
    }

    @Nonnull
    public CompletableFuture<ChunkAccess> fillFromNoise(@Nonnull Blender blender, @Nonnull RandomState randomState, @Nonnull StructureManager structureManager, @Nonnull ChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    @Nullable
    public Pair<BlockPos, Holder<Structure>> findNearestMapStructure(@Nonnull ServerLevel level, @Nonnull HolderSet<Structure> structureHolderSet, @Nonnull BlockPos pos, int searchRadius, boolean skipKnownStructures) {
        List<Holder> holders = structureHolderSet.stream().filter(holder -> holder.unwrapKey().isPresent() && StructuresConfig.structuresToGenerate.test(((ResourceKey)holder.unwrapKey().get()).location())).toList();
        HolderSet.Direct modifiedStructureHolderSet = HolderSet.direct(holders);
        for (Holder holder2 : modifiedStructureHolderSet) {
            if (!holder2.unwrapKey().isPresent() || !StructuresConfig.structuresToGenerate.test(((ResourceKey)holder2.unwrapKey().get()).location())) continue;
            return super.findNearestMapStructure(level, (HolderSet)modifiedStructureHolderSet, pos, searchRadius, skipKnownStructures);
        }
        return null;
    }

    public int getBaseHeight(int x, int z, @Nonnull Heightmap.Types heightmapType, @Nonnull LevelHeightAccessor level, @Nonnull RandomState randomState) {
        if (WorldConfig.surface) {
            return level.getMinBuildHeight() + this.layerHeight;
        }
        return this.parent.getBaseHeight(x, z, heightmapType, level, randomState);
    }

    public void applyCarvers(@Nonnull WorldGenRegion level, long seed, @Nonnull RandomState random, @Nonnull BiomeManager biomeManager, @Nonnull StructureManager structureManager, @Nonnull ChunkAccess chunk, @Nonnull GenerationStep.Carving step) {
        if (this.flatLayers.isEmpty()) {
            return;
        }
        NoiseChunk noiseChunk = chunk.getOrCreateNoiseChunk(otherChunk -> this.createNoiseChunk((ChunkAccess)otherChunk, structureManager, Blender.of((WorldGenRegion)level), random));
        ChunkPos chunkPos = chunk.getPos();
        Aquifer aquifer = noiseChunk.aquifer();
        CarvingMask carvingMask = ((ProtoChunk)chunk).getOrCreateCarvingMask(step);
        WorldgenRandom worldGenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(RandomSupport.generateUniqueSeed()));
        BiomeManager differentBiomeManager = biomeManager.withDifferentSource((x, y, z) -> this.biomeSource.getNoiseBiome(x, y, z, random.sampler()));
        CarvingContext carvingContext = new CarvingContext((NoiseBasedChunkGenerator)this, level.registryAccess(), chunk.getHeightAccessorForGeneration(), noiseChunk, random, ((NoiseGeneratorSettings)this.settings.value()).surfaceRule());
        int i = 8;
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                ChunkPos tempChunkPos = new ChunkPos(chunkPos.x + j, chunkPos.z + k);
                BiomeGenerationSettings biomeGenerationSettings = level.getChunk(tempChunkPos.x, tempChunkPos.z).carverBiome(() -> this.getBiomeGenerationSettings(this.biomeSource.getNoiseBiome(QuartPos.fromBlock((int)tempChunkPos.getMinBlockX()), 0, QuartPos.fromBlock((int)tempChunkPos.getMinBlockZ()), random.sampler())));
                int l = 0;
                for (Holder holder : biomeGenerationSettings.getCarvers(step)) {
                    if (holder.unwrapKey().isPresent() && !WorldConfig.carvers.get(this.dimension.location().toString()).test(((ResourceKey)holder.unwrapKey().get()).location())) continue;
                    ConfiguredWorldCarver configuredCarver = (ConfiguredWorldCarver)holder.value();
                    worldGenRandom.setLargeFeatureSeed(seed + (long)l, tempChunkPos.x, tempChunkPos.z);
                    if (configuredCarver.isStartChunk((RandomSource)worldGenRandom)) {
                        configuredCarver.carve(carvingContext, chunk, arg_0 -> ((BiomeManager)differentBiomeManager).getBiome(arg_0), (RandomSource)worldGenRandom, aquifer, tempChunkPos, carvingMask);
                    }
                    ++l;
                }
            }
        }
    }

    @Nonnull
    public NoiseColumn getBaseColumn(int posX, int posZ, @Nonnull LevelHeightAccessor level, @Nonnull RandomState randomState) {
        return new NoiseColumn(0, new BlockState[0]);
    }

    public void applyBiomeDecoration(@Nonnull WorldGenLevel level, @Nonnull ChunkAccess chunk, @Nonnull StructureManager structureManager) {
        ChunkPos chunkPos = chunk.getPos();
        SectionPos sectionPos = SectionPos.of((ChunkPos)chunkPos, (int)level.getMinSection());
        BlockPos blockpos = sectionPos.origin();
        Registry structureRegistry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
        Map<Integer, List<Structure>> map = structureRegistry.stream().collect(Collectors.groupingBy(structure -> structure.step().ordinal()));
        List stepFeatureDataList = (List)this.featuresPerStep.get();
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.generateUniqueSeed()));
        long decorationSeed = worldgenRandom.setDecorationSeed(level.getSeed(), blockpos.getX(), blockpos.getZ());
        ObjectArraySet possibleBiomes = new ObjectArraySet();
        ChunkPos.rangeClosed((ChunkPos)sectionPos.chunk(), (int)1).forEach(arg_0 -> SkyblockNoiseBasedChunkGenerator.lambda$applyBiomeDecoration$10(level, (Set)possibleBiomes, arg_0));
        possibleBiomes.retainAll(this.biomeSource.possibleBiomes());
        int dataSize = stepFeatureDataList.size();
        try {
            Registry placedFeatureRegistry = level.registryAccess().registryOrThrow(Registries.PLACED_FEATURE);
            int maxDecorations = Math.max(GenerationStep.Decoration.values().length, dataSize);
            for (int i = 0; i < maxDecorations; ++i) {
                Structure structure22;
                int index = 0;
                if (structureManager.shouldGenerateStructures()) {
                    for (Structure structure22 : map.getOrDefault(i, Collections.emptyList())) {
                        ResourceLocation location = level.registryAccess().registryOrThrow(Registries.STRUCTURE).getKey((Object)structure22);
                        if (!StructuresConfig.structuresToGenerate.test(location)) continue;
                        worldgenRandom.setFeatureSeed(decorationSeed, index, i);
                        Supplier<String> currentlyGenerating = () -> structureRegistry.getResourceKey((Object)structure22).map(Object::toString).orElseGet(structure22::toString);
                        try {
                            level.setCurrentlyGenerating(currentlyGenerating);
                            structureManager.startsForStructure(sectionPos, structure22).forEach(structureStart -> structureStart.placeInChunk(level, structureManager, (ChunkGenerator)this, (RandomSource)worldgenRandom, SkyblockNoiseBasedChunkGenerator.getWritableArea((ChunkAccess)chunk), chunkPos));
                        }
                        catch (Exception e) {
                            CrashReport report = CrashReport.forThrowable((Throwable)e, (String)"Feature placement");
                            report.addCategory("Feature").setDetail("Description", currentlyGenerating::get);
                            throw new ReportedException(report);
                        }
                        ++index;
                    }
                }
                if (i >= dataSize) continue;
                IntArraySet mapping = new IntArraySet();
                structure22 = possibleBiomes.iterator();
                while (structure22.hasNext()) {
                    Holder holder = (Holder)structure22.next();
                    List holderSets = ((BiomeGenerationSettings)this.generationSettingsGetter.apply(holder)).features();
                    if (i >= holderSets.size()) continue;
                    HolderSet featureHolderSet = (HolderSet)holderSets.get(i);
                    FeatureSorter.StepFeatureData stepFeatureData = (FeatureSorter.StepFeatureData)stepFeatureDataList.get(i);
                    featureHolderSet.stream().map(Holder::value).forEach(arg_0 -> SkyblockNoiseBasedChunkGenerator.lambda$applyBiomeDecoration$13((IntSet)mapping, stepFeatureData, arg_0));
                }
                int mappingSize = mapping.size();
                int[] array = mapping.toIntArray();
                Arrays.sort(array);
                FeatureSorter.StepFeatureData stepFeatureData = (FeatureSorter.StepFeatureData)stepFeatureDataList.get(i);
                for (int j = 0; j < mappingSize; ++j) {
                    int featureIndex = array[j];
                    PlacedFeature placedfeature = (PlacedFeature)stepFeatureData.features().get(featureIndex);
                    Optional optionalResourceKey = placedfeature.feature().unwrapKey();
                    if (optionalResourceKey.isPresent() && !StructuresConfig.featuresToGenerate.test(((ResourceKey)optionalResourceKey.get()).location())) continue;
                    Supplier<String> currentlyGenerating = () -> placedFeatureRegistry.getResourceKey((Object)placedfeature).map(Object::toString).orElseGet(() -> ((PlacedFeature)placedfeature).toString());
                    worldgenRandom.setFeatureSeed(decorationSeed, featureIndex, i);
                    try {
                        level.setCurrentlyGenerating(currentlyGenerating);
                        placedfeature.placeWithBiomeCheck(level, (ChunkGenerator)this, (RandomSource)worldgenRandom, blockpos);
                        continue;
                    }
                    catch (Exception e) {
                        CrashReport report = CrashReport.forThrowable((Throwable)e, (String)"Feature placement");
                        report.addCategory("Feature").setDetail("Description", currentlyGenerating::get);
                        throw new ReportedException(report);
                    }
                }
            }
            level.setCurrentlyGenerating(null);
        }
        catch (Exception e) {
            CrashReport report = CrashReport.forThrowable((Throwable)e, (String)"Biome decoration");
            report.addCategory("Generation").setDetail("CenterX", (Object)chunkPos.x).setDetail("CenterZ", (Object)chunkPos.z).setDetail("Seed", (Object)decorationSeed);
            throw new ReportedException(report);
        }
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public FlatLayers getFlatLayers() {
        return this.flatLayers;
    }

    private static /* synthetic */ void lambda$applyBiomeDecoration$13(IntSet mapping, FeatureSorter.StepFeatureData stepFeatureData, PlacedFeature placedFeature) {
        mapping.add(stepFeatureData.indexMapping().applyAsInt(placedFeature));
    }

    private static /* synthetic */ void lambda$applyBiomeDecoration$10(WorldGenLevel level, Set possibleBiomes, ChunkPos pos) {
        ChunkAccess chunkaccess = level.getChunk(pos.x, pos.z);
        for (LevelChunkSection chunkSection : chunkaccess.getSections()) {
            chunkSection.getBiomes().getAll(possibleBiomes::add);
        }
    }
}

