/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.config.common.WorldConfig;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;

public class SkyBiomeSource
extends MultiNoiseBiomeSource {
    private final List<CenterBiome> centerBiomes;
    private final MultiNoiseBiomeSource parent;
    public static final MapCodec<SkyBiomeSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.list((Codec)CenterBiome.CODEC.codec()).fieldOf("center_biome").forGetter(biomeSource -> biomeSource.centerBiomes), (App)MultiNoiseBiomeSource.CODEC.fieldOf("parent").forGetter(biomeSource -> biomeSource.parent)).apply((Applicative)instance, SkyBiomeSource::new));

    public SkyBiomeSource(List<CenterBiome> centerBiomes, MultiNoiseBiomeSource parent) {
        super(parent.parameters);
        this.centerBiomes = centerBiomes;
        this.parent = parent;
    }

    @Nonnull
    protected MapCodec<? extends BiomeSource> codec() {
        return CODEC;
    }

    @Nonnull
    public Holder<Biome> getNoiseBiome(int x, int y, int z, @Nonnull Climate.Sampler sampler) {
        int radius = 0;
        int blockX = this.calculateCenteredBlockPos(QuartPos.toBlock((int)x));
        int blockZ = this.calculateCenteredBlockPos(QuartPos.toBlock((int)z));
        for (CenterBiome centerBiome : this.centerBiomes) {
            if (blockX * blockX + blockZ * blockZ >= (radius += centerBiome.radius()) * radius) continue;
            return centerBiome.biome();
        }
        return super.getNoiseBiome(x, y, z, sampler);
    }

    private int calculateCenteredBlockPos(int i) {
        int div = WorldConfig.islandDistance;
        int blockPos = ((i - TemplatesConfig.defaultOffset) % div + div) % div;
        if (blockPos > div / 2) {
            blockPos -= div;
        }
        return blockPos;
    }

    public record CenterBiome(Holder<Biome> biome, int radius) {
        public static final MapCodec<CenterBiome> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Biome.CODEC.fieldOf("id").forGetter(CenterBiome::biome), (App)Codec.INT.fieldOf("radius").forGetter(CenterBiome::radius)).apply((Applicative)instance, CenterBiome::new));
    }
}

