/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.config.StartingInventory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.neoforged.fml.loading.FMLPaths;

public class SkyPaths {
    public static final Path MOD_CONFIG = FMLPaths.CONFIGDIR.get().resolve("skyblockbuilder");
    public static final Path SKYBLOCK_UTILS = FMLPaths.GAMEDIR.get().resolve("skyblockbuilder");
    public static final Path MOD_EXPORTS = SKYBLOCK_UTILS.resolve("exports");
    public static final Path CONVERT_INPUT = SKYBLOCK_UTILS.resolve("convert_input");
    public static final Path CONVERT_OUTPUT = SKYBLOCK_UTILS.resolve("convert_output");
    public static final Path DUMPS = SKYBLOCK_UTILS.resolve("dumps");
    public static final Path TEMPLATES_DIR = MOD_CONFIG.resolve("templates");
    public static final Path ISLANDS_DIR = TEMPLATES_DIR.resolve("islands");
    public static final Path SPREADS_DIR = TEMPLATES_DIR.resolve("spreads");
    public static final Path PORTALS_DIR = TEMPLATES_DIR.resolve("portals");
    public static final Path ICONS_DIR = TEMPLATES_DIR.resolve("icons");
    public static final Path DATA_DIR = MOD_CONFIG.resolve("data");
    public static final Path ITEMS_FILE = MOD_CONFIG.resolve("starter_inventory.json5");
    public static final Path SCHEMATIC_FILE = ISLANDS_DIR.resolve("default.nbt");
    private static final Path FEATURES_FILE = DATA_DIR.resolve("features.txt");
    private static final Path STRUCTURES_FILE = DATA_DIR.resolve("structures.txt");
    private static final Path BIOMES_FILE = DATA_DIR.resolve("biomes.txt");
    private static final Path CARVERS_FILE = DATA_DIR.resolve("carvers.txt");
    private static final Path DIMENSIONS_FILE = DATA_DIR.resolve("dimensions.txt");
    private static final Path PORTALS_INFORMATION_FILE = PORTALS_DIR.resolve("information.txt");
    public static final Predicate<File> NBT_OR_SNBT = file -> file.isFile() && (file.getName().endsWith(".nbt") || file.getName().endsWith(".snbt"));

    public static void createDirectories() {
        try {
            Files.createDirectories(MOD_CONFIG, new FileAttribute[0]);
            Files.createDirectories(SKYBLOCK_UTILS, new FileAttribute[0]);
            Files.createDirectories(MOD_EXPORTS, new FileAttribute[0]);
            Files.createDirectories(CONVERT_INPUT, new FileAttribute[0]);
            Files.createDirectories(CONVERT_OUTPUT, new FileAttribute[0]);
            Files.createDirectories(DUMPS, new FileAttribute[0]);
            Files.createDirectories(TEMPLATES_DIR, new FileAttribute[0]);
            Files.createDirectories(ISLANDS_DIR, new FileAttribute[0]);
            Files.createDirectories(SPREADS_DIR, new FileAttribute[0]);
            Files.createDirectories(PORTALS_DIR, new FileAttribute[0]);
            Files.createDirectories(ICONS_DIR, new FileAttribute[0]);
            Files.createDirectories(DATA_DIR, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create default directories.", e);
        }
    }

    public static void generateDefaultFiles(@Nullable MinecraftServer server) {
        try {
            SkyPaths.createDirectories();
            SkyPaths.copyTemplateFile();
            SkyPaths.writePortalsInformation();
            SkyPaths.generateStarterItemsFile();
            if (server != null) {
                SkyPaths.generateFeatureInformation(server);
                SkyPaths.generateStructureInformation(server);
                SkyPaths.generateBiomeInformation(server);
                SkyPaths.generateCarversInformation(server);
                SkyPaths.generateDimensionInformation(server);
                StartingInventory.loadStarterItems((RegistryAccess)server.registryAccess());
            }
        }
        catch (IOException e) {
            SkyblockBuilder.getLogger().error("Unable to generate default files", (Throwable)e);
        }
    }

    public static void copyTemplateFile() throws IOException {
        if (Arrays.stream(ISLANDS_DIR.toFile().listFiles()).anyMatch(NBT_OR_SNBT)) {
            return;
        }
        Files.copy(SkyblockBuilder.class.getResourceAsStream("/skyblockbuilder-template.nbt"), SCHEMATIC_FILE, new CopyOption[0]);
    }

    public static void writePortalsInformation() throws IOException {
        String fileContent = "This directory is only for providing custom portals. At the moment, you only may set a custom portal when entering the nether.\nTo do so, call your file \"to_nether.nbt\" or \"to_nether.snbt\".\nIt needs to contain at least one nether portal block. If that is destroyed, the structure would re-generate when re-entering the nether.";
        if (Files.exists(PORTALS_INFORMATION_FILE, new LinkOption[0]) && Files.readString(PORTALS_INFORMATION_FILE).equals(fileContent)) {
            return;
        }
        Files.writeString(PORTALS_INFORMATION_FILE, (CharSequence)fileContent, new OpenOption[0]);
    }

    private static void generateStarterItemsFile() throws IOException {
        if (Files.isRegularFile(ITEMS_FILE, new LinkOption[0])) {
            return;
        }
        JsonObject object = new JsonObject();
        JsonArray items = new JsonArray();
        object.add("items", (JsonElement)items);
        BufferedWriter w = Files.newBufferedWriter(ITEMS_FILE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        w.write("// See here for more information:\n");
        w.write("// https://wiki.chaotictrials.de/docs/wiki/skyblock-builder/packdev/configs/starting-inventory\n");
        w.write("// If this page isn't available, go to the project page (where you downloaded the file), and click on the wiki\n");
        w.write(SkyblockBuilder.PRETTY_GSON.toJson((JsonElement)object));
        w.close();
    }

    public static void generateFeatureInformation(MinecraftServer server) throws IOException {
        BufferedWriter w = Files.newBufferedWriter(FEATURES_FILE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        Stream stream = server.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE).holders();
        stream.sorted(Comparator.comparing(holder -> holder.key().location().toString())).forEach(holder -> {
            try {
                w.write(String.valueOf(holder.key().location()) + "\n");
            }
            catch (IOException e) {
                SkyblockBuilder.getLogger().error("Failed to write '{}' to file", (Object)holder.key().location(), (Object)e);
            }
        });
        w.close();
    }

    public static void generateStructureInformation(MinecraftServer server) throws IOException {
        BufferedWriter w = Files.newBufferedWriter(STRUCTURES_FILE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        Stream stream = server.registryAccess().registryOrThrow(Registries.STRUCTURE).holders();
        stream.sorted(Comparator.comparing(holder -> holder.key().location().toString())).forEach(holder -> {
            try {
                w.write(String.valueOf(holder.key().location()) + "\n");
            }
            catch (IOException e) {
                SkyblockBuilder.getLogger().error("Failed to write '{}' to file", (Object)holder.key().location(), (Object)e);
            }
        });
        w.close();
    }

    public static void generateBiomeInformation(MinecraftServer server) throws IOException {
        BufferedWriter w = Files.newBufferedWriter(BIOMES_FILE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        Stream stream = server.registryAccess().registryOrThrow(Registries.BIOME).holders();
        stream.sorted(Comparator.comparing(holder -> holder.key().location().toString())).forEach(holder -> {
            try {
                w.write(String.valueOf(holder.key().location()) + "\n");
            }
            catch (IOException e) {
                SkyblockBuilder.getLogger().error("Failed to write '{}' to file", (Object)holder.key().location(), (Object)e);
            }
        });
        w.close();
    }

    public static void generateCarversInformation(MinecraftServer server) throws IOException {
        BufferedWriter w = Files.newBufferedWriter(CARVERS_FILE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        Stream stream = server.registryAccess().registryOrThrow(Registries.CONFIGURED_CARVER).holders();
        stream.sorted(Comparator.comparing(holder -> holder.key().location().toString())).forEach(holder -> {
            try {
                w.write(String.valueOf(holder.key().location()) + "\n");
            }
            catch (IOException e) {
                SkyblockBuilder.getLogger().error("Failed to write '{}' to file", (Object)holder.key().location(), (Object)e);
            }
        });
        w.close();
    }

    public static void generateDimensionInformation(@Nonnull MinecraftServer server) throws IOException {
        BufferedWriter w = Files.newBufferedWriter(DIMENSIONS_FILE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        for (ResourceKey levelKey : server.levelKeys()) {
            w.write(String.valueOf(levelKey.location()) + "\n");
        }
        w.close();
    }
}

