/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.util;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;

public class PositionHelper {
    public static BlockPos findPos(BlockPos center, Predicate<BlockPos> condition, int maxStep) {
        for (int i = 0; i < maxStep; ++i) {
            Optional<BlockPos> result = PositionHelper.doFindPos(center, condition, i);
            if (!result.isPresent()) continue;
            return result.get();
        }
        return center;
    }

    public static Optional<BlockPos> doFindPos(BlockPos center, Predicate<BlockPos> condition, int step) {
        return IntStream.range(0, step).boxed().flatMap(i -> PositionHelper.findInRing(center.offset(0, i.intValue(), 0), condition, step).or(() -> PositionHelper.findInRing(center.offset(0, -i.intValue(), 0), condition, step)).stream()).findFirst().or(() -> PositionHelper.findInHorSpiral(center.offset(0, step, 0), condition, step)).or(() -> PositionHelper.findInHorSpiral(center.offset(0, -step, 0), condition, step));
    }

    public static Optional<BlockPos> findInRing(BlockPos center, Predicate<BlockPos> condition, int size) {
        int dz;
        int dx;
        BlockPos.MutableBlockPos mpos = center.mutable();
        mpos.move(-size, 0, -size);
        for (dx = 0; dx < 2 * size; ++dx) {
            if (condition.test((BlockPos)mpos)) {
                return Optional.of(mpos.immutable());
            }
            mpos.move(1, 0, 0);
        }
        for (dz = 0; dz < 2 * size; ++dz) {
            if (condition.test((BlockPos)mpos)) {
                return Optional.of(mpos.immutable());
            }
            mpos.move(0, 0, 1);
        }
        for (dx = 0; dx < 2 * size; ++dx) {
            if (condition.test((BlockPos)mpos)) {
                return Optional.of(mpos.immutable());
            }
            mpos.move(-1, 0, 0);
        }
        for (dz = 0; dz < 2 * size; ++dz) {
            if (condition.test((BlockPos)mpos)) {
                return Optional.of(mpos.immutable());
            }
            mpos.move(0, 0, -1);
        }
        return Optional.empty();
    }

    public static Optional<BlockPos> findInHorSpiral(BlockPos center, Predicate<BlockPos> condition, int size) {
        BlockPos.MutableBlockPos mpos = center.mutable();
        int dx = 0;
        int dz = -1;
        for (int i = 0; i < size; ++i) {
            if (mpos.getX() == mpos.getZ() || mpos.getX() == 0 && mpos.getX() == -mpos.getZ() || mpos.getX() > 0 && mpos.getX() == 1 - mpos.getZ()) {
                int t = dx;
                dx = -dz;
                dz = t;
            }
            mpos.offset(dx, 0, dz);
            if (!condition.test((BlockPos)mpos)) continue;
            return Optional.of(mpos.immutable());
        }
        return Optional.empty();
    }
}

