/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.template;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.client.FakeLevel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import org.moddingx.libx.render.ClientTickHandler;

public class TemplateRenderer {
    private final ClientLevel clientLevel = Objects.requireNonNull(FakeLevel.getInstance());
    private final StructureTemplate template;
    private final transient Map<BlockPos, BlockEntity> teCache = new HashMap<BlockPos, BlockEntity>();
    private final transient Set<BlockEntity> erroredTiles = Collections.newSetFromMap(new WeakHashMap());
    private final transient Set<Entity> erroredEntities = Collections.newSetFromMap(new WeakHashMap());
    private final boolean fixedPaletteIndex;
    private int paletteIndex;
    private float maxX;
    private float maxY;

    public TemplateRenderer(StructureTemplate template, float maxSize) {
        this(template, maxSize, maxSize, -1);
    }

    public TemplateRenderer(StructureTemplate template, float maxSize, int fixedPaletteIndex) {
        this(template, maxSize, maxSize, fixedPaletteIndex);
    }

    public TemplateRenderer(StructureTemplate template, float maxX, float maxY, int fixedPaletteIndex) {
        this.template = template;
        this.maxX = maxX;
        this.maxY = maxY;
        this.fixedPaletteIndex = fixedPaletteIndex != -1;
        this.paletteIndex = this.fixedPaletteIndex ? fixedPaletteIndex : 0;
    }

    public void setSize(float size) {
        this.setSize(size, size);
    }

    public void setSize(float maxX, float maxY) {
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public void render(GuiGraphics guiGraphics, int xPos, int yPos) {
        Vec3i size = this.template.getSize();
        int sizeX = size.getX();
        int sizeY = size.getY();
        int sizeZ = size.getZ();
        float diagonal = (float)Math.sqrt(sizeX * sizeX + sizeZ * sizeZ);
        float scaleX = this.maxX / diagonal;
        float scaleY = this.maxY / (float)sizeY;
        float scale = -Math.min(scaleX, scaleY);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)xPos, (float)yPos, 100.0f);
        guiGraphics.pose().scale(scale, scale, scale);
        guiGraphics.pose().translate(-((float)sizeX) / 2.0f, -((float)sizeY) / 2.0f, 0.0f);
        Vector4f eye = new Vector4f(0.0f, 0.0f, -100.0f, 1.0f);
        Matrix4f rotMat = new Matrix4f();
        rotMat.identity();
        guiGraphics.pose().mulPose(Axis.XP.rotationDegrees(-30.0f));
        rotMat.rotation((Quaternionfc)Axis.XP.rotationDegrees(30.0f));
        float offX = (float)(-sizeX) / 2.0f;
        float offZ = (float)(-sizeZ) / 2.0f + 1.0f;
        float time = ClientTickHandler.ticksInGame();
        guiGraphics.pose().translate(-offX, 0.0f, -offZ);
        guiGraphics.pose().mulPose(Axis.YP.rotationDegrees(time));
        rotMat.rotation((Quaternionfc)Axis.YP.rotationDegrees(-time));
        guiGraphics.pose().mulPose(Axis.YP.rotationDegrees(45.0f));
        rotMat.rotation((Quaternionfc)Axis.YP.rotationDegrees(-45.0f));
        guiGraphics.pose().translate(offX, 0.0f, offZ);
        eye.mul((Matrix4fc)rotMat);
        this.renderElements(guiGraphics, this.template);
        guiGraphics.pose().popPose();
        if (ClientTickHandler.ticksInGame() % 40 == 0) {
            if (this.fixedPaletteIndex) {
                return;
            }
            ++this.paletteIndex;
            if (this.paletteIndex >= this.template.palettes.size()) {
                this.paletteIndex = 0;
            }
        }
    }

    private void renderElements(GuiGraphics guiGraphics, StructureTemplate template) {
        guiGraphics.pose().pushPose();
        ItemBlockRenderTypes.setFancy((boolean)Minecraft.useFancyGraphics());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.pose().translate(0.0f, 0.0f, -1.0f);
        MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
        this.doWorldRenderPass(guiGraphics, template, buffers);
        this.doTileEntityRenderPass(guiGraphics, template, (MultiBufferSource)buffers);
        this.doEntityRenderPass(guiGraphics, template, (MultiBufferSource)buffers);
        buffers.endBatch();
        guiGraphics.pose().popPose();
    }

    private void doWorldRenderPass(GuiGraphics guiGraphics, StructureTemplate template, MultiBufferSource.BufferSource buffers) {
        StructureTemplate.Palette palette = (StructureTemplate.Palette)template.palettes.get(this.paletteIndex);
        for (StructureTemplate.StructureBlockInfo blockInfo : palette.blocks()) {
            BlockPos pos = blockInfo.pos();
            BlockState bs = blockInfo.state();
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            this.renderForMultiblock(bs, pos, guiGraphics, buffers);
            guiGraphics.pose().popPose();
        }
    }

    private void renderForMultiblock(BlockState state, BlockPos pos, GuiGraphics guiGraphics, MultiBufferSource.BufferSource buffers) {
        if (state.getRenderShape() == RenderShape.MODEL) {
            BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
            BakedModel model = blockRenderer.getBlockModel(state);
            for (RenderType layer : model.getRenderTypes(state, this.clientLevel.random, ModelData.EMPTY)) {
                guiGraphics.pose().pushPose();
                Lighting.setupForFlatItems();
                Vec3 vec3 = state.getOffset((BlockGetter)this.clientLevel, pos);
                guiGraphics.pose().translate(vec3.x, vec3.y, vec3.z);
                blockRenderer.renderSingleBlock(state, guiGraphics.pose(), (MultiBufferSource)buffers, 192, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, layer);
                guiGraphics.pose().popPose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTileEntityRenderPass(GuiGraphics guiGraphics, StructureTemplate template, MultiBufferSource buffers) {
        StructureTemplate.Palette palette = (StructureTemplate.Palette)template.palettes.get(this.paletteIndex);
        for (StructureTemplate.StructureBlockInfo blockInfo : palette.blocks()) {
            BlockPos pos = blockInfo.pos();
            BlockState state = blockInfo.state();
            BlockEntity te = null;
            if (state.getBlock() instanceof EntityBlock) {
                te = this.teCache.computeIfAbsent(pos.immutable(), p -> ((EntityBlock)state.getBlock()).newBlockEntity(pos, state));
            }
            if (te == null || this.erroredTiles.contains(te)) continue;
            te.setLevel((Level)this.clientLevel);
            te.setBlockState(state);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            try {
                BlockEntityRenderer renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(te);
                if (renderer == null) continue;
                renderer.render(te, 0.0f, guiGraphics.pose(), buffers, LightTexture.pack((int)15, (int)15), OverlayTexture.NO_OVERLAY);
            }
            catch (Exception e) {
                this.erroredTiles.add(te);
                SkyblockBuilder.getLogger().error("An exception occurred rendering tile entity", (Throwable)e);
            }
            finally {
                guiGraphics.pose().popPose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEntityRenderPass(GuiGraphics guiGraphics, StructureTemplate template, MultiBufferSource buffers) {
        for (StructureTemplate.StructureEntityInfo entityInfo : template.entityInfoList) {
            Optional maybe = EntityType.create((CompoundTag)entityInfo.nbt, (Level)this.clientLevel);
            if (!maybe.isPresent()) continue;
            Vec3 pos = entityInfo.pos;
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(pos.x(), pos.y(), pos.z());
            Entity entity = (Entity)maybe.get();
            if (this.erroredEntities.contains(entity)) continue;
            try {
                EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
                entityRenderDispatcher.prepare((Level)this.clientLevel, Minecraft.getInstance().gameRenderer.getMainCamera(), entity);
                EntityRenderer renderer = entityRenderDispatcher.getRenderer(entity);
                renderer.render(entity, entity.getYRot(), 0.0f, guiGraphics.pose(), buffers, LightTexture.pack((int)15, (int)15));
            }
            catch (Exception e) {
                this.erroredEntities.add(entity);
                SkyblockBuilder.getLogger().error("An exception occurred rendering entity", (Throwable)e);
            }
            finally {
                guiGraphics.pose().popPose();
            }
        }
    }
}

