/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.network;

import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.data.SkyMeta;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import org.moddingx.libx.network.PacketHandler;

public class SkyblockDataUpdateHandler
extends PacketHandler<Message> {
    public static final CustomPacketPayload.Type<Message> TYPE = new CustomPacketPayload.Type(SkyblockBuilder.getInstance().resource("skyblock_data_update"));

    protected SkyblockDataUpdateHandler() {
        super(TYPE, PacketFlow.CLIENTBOUND, Message.CODEC, HandlerThread.MAIN);
    }

    public void handle(Message msg, IPayloadContext ctx) {
        SkyblockSavedData.updateClient(msg.data);
    }

    public record Message(SkyblockSavedData data, UUID player) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Message> CODEC = StreamCodec.of((buffer, msg) -> {
            CompoundTag tag = msg.data.save(new CompoundTag(), (HolderLookup.Provider)msg.data.getLevel().registryAccess());
            if (tag.contains("MetaInformation")) {
                SkyMeta meta = null;
                for (Tag inbt : tag.getList("MetaInformation", 10)) {
                    CompoundTag mtag = (CompoundTag)inbt;
                    UUID player = mtag.getUUID("Player");
                    if (!msg.player.equals(player)) continue;
                    meta = SkyMeta.get(msg.data, mtag.getCompound("Meta"));
                    break;
                }
                tag.remove("MetaInformation");
                if (meta != null) {
                    ListTag metaInfo = new ListTag();
                    CompoundTag playerMeta = new CompoundTag();
                    playerMeta.putUUID("Player", msg.player);
                    playerMeta.put("Meta", (Tag)meta.save());
                    metaInfo.add((Object)playerMeta);
                    tag.put("MetaInformation", (Tag)metaInfo);
                }
            }
            buffer.writeNbt((Tag)tag);
            buffer.writeUUID(msg.player);
        }, buffer -> {
            Tag tag = buffer.readNbt(NbtAccounter.unlimitedHeap());
            SkyblockSavedData data = SkyblockSavedData.load((CompoundTag)tag);
            return new Message(data, buffer.readUUID());
        });

        @Nonnull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

