/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.network;

import com.mojang.authlib.GameProfile;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.item.StructureSaverSettings;
import de.melanx.skyblockbuilder.network.CreateSkyblockDumpHandler;
import de.melanx.skyblockbuilder.network.DeleteTagsHandler;
import de.melanx.skyblockbuilder.network.GiveItemHandler;
import de.melanx.skyblockbuilder.network.ProfilesUpdateHandler;
import de.melanx.skyblockbuilder.network.SaveStructureHandler;
import de.melanx.skyblockbuilder.network.SkyblockDataUpdateHandler;
import de.melanx.skyblockbuilder.network.UpdateStructureSaverSettingsHandler;
import de.melanx.skyblockbuilder.network.UpdateStructureSaverTypeHandler;
import de.melanx.skyblockbuilder.network.UpdateTemplateNamesHandler;
import de.melanx.skyblockbuilder.util.RandomUtility;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.network.NetworkX;

public class SkyNetwork
extends NetworkX {
    public SkyNetwork(ModX mod) {
        super(mod);
        this.register(new SaveStructureHandler());
        this.register(new DeleteTagsHandler());
        this.register(new CreateSkyblockDumpHandler());
        this.register(new GiveItemHandler());
        this.register(new UpdateStructureSaverTypeHandler());
        this.register(new UpdateStructureSaverSettingsHandler());
        this.register(new SkyblockDataUpdateHandler());
        this.register(new ProfilesUpdateHandler());
        this.register(new UpdateTemplateNamesHandler());
    }

    protected String getVersion() {
        return "13";
    }

    public void updateData(Level level, SkyblockSavedData data) {
        if (!level.isClientSide) {
            for (ServerPlayer player : ((ServerLevel)level).getServer().getPlayerList().getPlayers()) {
                this.updateData((Player)player, data);
            }
        }
    }

    public void updateData(Player player, @Nullable SkyblockSavedData data) {
        if (!player.getCommandSenderWorld().isClientSide) {
            SkyblockDataUpdateHandler.Message msg = new SkyblockDataUpdateHandler.Message(data != null ? data : SkyblockSavedData.get(player.getCommandSenderWorld()), player.getGameProfile().getId());
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void deleteTags(ItemStack stack) {
        PacketDistributor.sendToServer((CustomPacketPayload)new DeleteTagsHandler.Message(stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void createSkyblockDump(boolean includeConfigs, boolean includeTemplates, boolean includeLevelDat, boolean includeLog, boolean includeCrashReport, boolean includeSkyblockBuilderWorldData) {
        PacketDistributor.sendToServer((CustomPacketPayload)new CreateSkyblockDumpHandler.Message(includeConfigs, includeTemplates, includeLevelDat, includeLog, includeCrashReport, includeSkyblockBuilderWorldData), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void saveStructure(ItemStack stack, StructureSaverSettings settings) {
        PacketDistributor.sendToServer((CustomPacketPayload)new SaveStructureHandler.Message(stack, settings), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void giveItem(Item item) {
        PacketDistributor.sendToServer((CustomPacketPayload)new GiveItemHandler.Message(item), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void changeStructureSaverType(ItemStack stack, StructureSaverSettings.Type type) {
        PacketDistributor.sendToServer((CustomPacketPayload)new UpdateStructureSaverTypeHandler.Message(stack, type), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void updateStructureSaverSettings(ItemStack stack, StructureSaverSettings settings) {
        PacketDistributor.sendToServer((CustomPacketPayload)new UpdateStructureSaverSettingsHandler.Message(stack, settings), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void updateProfiles(Player player) {
        if (player.getCommandSenderWorld().isClientSide) {
            return;
        }
        this.sendProfilesInBatches((ServerPlayer)player, RandomUtility.getGameProfiles((ServerLevel)player.getCommandSenderWorld()));
    }

    public void updateProfiles(Level level) {
        if (level.isClientSide) {
            return;
        }
        Set<GameProfile> gameProfiles = RandomUtility.getGameProfiles((ServerLevel)level);
        this.sendProfilesInBatches(null, gameProfiles);
    }

    public void updateTemplateNames(Player player, List<String> names) {
        if (player.level().isClientSide) {
            return;
        }
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new UpdateTemplateNamesHandler.Message(names), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void updateTemplateNames(List<String> names) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new UpdateTemplateNamesHandler.Message(names), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void sendProfilesInBatches(ServerPlayer player, Set<GameProfile> allGameProfiles) {
        int batchSize = 1000;
        HashSet<GameProfile> currentBatch = new HashSet<GameProfile>(1000);
        for (GameProfile profile : allGameProfiles) {
            currentBatch.add(profile);
            if (currentBatch.size() != 1000) continue;
            this.sendProfileBatch(player, currentBatch);
            currentBatch.clear();
        }
        if (!currentBatch.isEmpty()) {
            this.sendProfileBatch(player, currentBatch);
        }
    }

    private void sendProfileBatch(ServerPlayer player, Set<GameProfile> profiles) {
        ProfilesUpdateHandler.Message msg = new ProfilesUpdateHandler.Message(profiles);
        if (player == null) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

