/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.network;

import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.DumpUtil;
import de.melanx.skyblockbuilder.util.SkyComponents;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import org.moddingx.libx.network.PacketHandler;

public class CreateSkyblockDumpHandler
extends PacketHandler<Message> {
    public static final CustomPacketPayload.Type<Message> TYPE = new CustomPacketPayload.Type(SkyblockBuilder.getInstance().resource("create_skyblock_dump"));

    protected CreateSkyblockDumpHandler() {
        super(TYPE, PacketFlow.SERVERBOUND, Message.CODEC, HandlerThread.MAIN);
    }

    public void handle(Message msg, IPayloadContext ctx) {
        Player player = ctx.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!PermissionManager.INSTANCE.mayExecuteOpCommand((Player)player2)) {
            player2.sendSystemMessage((Component)SkyComponents.SCREEN_DUMP_FAILURE);
            return;
        }
        Path zip = DumpUtil.createZip(msg.includeConfigs, msg.includeTemplates, msg.includeLevelDat, msg.includeLog, msg.includeCrashReport, msg.includeSkyblockBuilderWorldData);
        player2.sendSystemMessage((Component)SkyComponents.SCREEN_DUMP_SUCCESS.apply(String.valueOf(FMLPaths.GAMEDIR.get().relativize(zip))).append(" ").append((Component)SkyComponents.SCREEN_DUMP_SUCCESS_SERVER));
        player2.sendSystemMessage((Component)SkyComponents.SCREEN_DUMP_CREATE_ISSUE.append(" ").append(DumpUtil.getIssueUrl()));
    }

    public record Message(boolean includeConfigs, boolean includeTemplates, boolean includeLevelDat, boolean includeLog, boolean includeCrashReport, boolean includeSkyblockBuilderWorldData) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Message> CODEC = StreamCodec.of((buffer, msg) -> {
            buffer.writeBoolean(msg.includeConfigs);
            buffer.writeBoolean(msg.includeTemplates);
            buffer.writeBoolean(msg.includeLevelDat);
            buffer.writeBoolean(msg.includeLog);
            buffer.writeBoolean(msg.includeCrashReport);
            buffer.writeBoolean(msg.includeSkyblockBuilderWorldData);
        }, buffer -> new Message(buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean()));

        @Nonnull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

