/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.item;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.client.ClientUtil;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.item.StructureSaverSettings;
import de.melanx.skyblockbuilder.registration.ModDataComponentTypes;
import de.melanx.skyblockbuilder.spreads.SpreadInfo;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.util.SkyPaths;
import de.melanx.skyblockbuilder.util.TemplateUtil;
import de.melanx.skyblockbuilder.util.WorldUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import org.moddingx.libx.config.ConfigManager;

public class ItemStructureSaver
extends Item {
    private static final MutableComponent TOOLTIP_INFO = SkyComponents.ITEM_STRUCTURE_SAVER_INFO_TOOLTIP.withStyle(ChatFormatting.GOLD);
    private static final MutableComponent TOOLTIP_SAVE = SkyComponents.ITEM_STRUCTURE_SAVER_SAVE_TOOLTIP.withStyle(ChatFormatting.GOLD);
    private static final MutableComponent TOOLTIP_RESTORE = SkyComponents.ITEM_STRUCTURE_SAVER_RESTORE_TOOLTIP.withStyle(ChatFormatting.GOLD);

    public ItemStructureSaver() {
        super(new Item.Properties().stacksTo(1));
    }

    @Nonnull
    public InteractionResult useOn(@Nonnull UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (!context.getLevel().isClientSide && player != null && player.isShiftKeyDown()) {
            ItemStack stack = context.getItemInHand();
            CompoundTag positions = (CompoundTag)stack.get(ModDataComponentTypes.positions);
            if (positions == null) {
                positions = new CompoundTag();
            }
            if (!positions.contains("Position1")) {
                positions.put("Position1", NbtUtils.writeBlockPos((BlockPos)pos));
                player.displayClientMessage((Component)SkyComponents.STRUCTURE_SAVER_POS.apply((Object)1, (Object)pos.getX(), (Object)pos.getY(), (Object)pos.getZ()), false);
                stack.remove(ModDataComponentTypes.previousPositions);
                stack.set(ModDataComponentTypes.positions, (Object)positions);
                return InteractionResult.SUCCESS;
            }
            if (!positions.contains("Position2")) {
                positions.put("Position2", NbtUtils.writeBlockPos((BlockPos)pos));
                player.displayClientMessage((Component)SkyComponents.STRUCTURE_SAVER_POS.apply((Object)2, (Object)pos.getX(), (Object)pos.getY(), (Object)pos.getZ()), false);
                stack.set(ModDataComponentTypes.positions, (Object)positions.copy());
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean onEntitySwing(@Nonnull ItemStack stack, @Nonnull LivingEntity entity, @Nonnull InteractionHand hand) {
        CompoundTag previousPositions = (CompoundTag)stack.get(ModDataComponentTypes.previousPositions);
        if (previousPositions != null && entity.isShiftKeyDown()) {
            ItemStructureSaver.restorePositions(stack);
        }
        return super.onEntitySwing(stack, entity, hand);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        CompoundTag positions = (CompoundTag)stack.get(ModDataComponentTypes.positions);
        if (positions == null) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (!positions.contains("Position1") || !positions.contains("Position2")) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (!positions.contains("CanSave")) {
            positions.putBoolean("CanSave", true);
            return InteractionResultHolder.pass((Object)stack);
        }
        if (level.isClientSide) {
            ClientUtil.openItemScreen(stack);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag tooltipFlag) {
        Optional pos;
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        tooltip.add(((StructureSaverSettings.Type)((Object)stack.getOrDefault(ModDataComponentTypes.structureSaverType, (Object)StructureSaverSettings.Type.ISLAND))).getTooltip());
        CompoundTag positions = (CompoundTag)stack.get(ModDataComponentTypes.positions);
        if (positions == null) {
            positions = new CompoundTag();
        }
        if (positions.contains("Position1")) {
            pos = NbtUtils.readBlockPos((CompoundTag)positions, (String)"Position1");
            pos.ifPresent(blockPos -> tooltip.add((Component)((MutableComponent)SkyComponents.ITEM_STRUCTURE_SAVER_POSITION_TOOLTIP.apply((Object)1, (Object)blockPos.getX(), (Object)blockPos.getY(), (Object)blockPos.getZ())).withStyle(ChatFormatting.DARK_GRAY)));
        }
        if (positions.contains("Position2")) {
            pos = NbtUtils.readBlockPos((CompoundTag)positions, (String)"Position2");
            pos.ifPresent(blockPos -> tooltip.add((Component)((MutableComponent)SkyComponents.ITEM_STRUCTURE_SAVER_POSITION_TOOLTIP.apply((Object)2, (Object)blockPos.getX(), (Object)blockPos.getY(), (Object)blockPos.getZ())).withStyle(ChatFormatting.DARK_GRAY)));
        }
        if (positions.contains("CanSave")) {
            tooltip.add((Component)TOOLTIP_SAVE);
        } else {
            tooltip.add((Component)TOOLTIP_INFO);
        }
        CompoundTag previousPositions = (CompoundTag)stack.get(ModDataComponentTypes.previousPositions);
        if (previousPositions != null) {
            tooltip.add((Component)TOOLTIP_RESTORE);
        }
    }

    @Nullable
    public static BoundingBox getArea(ItemStack stack) {
        CompoundTag positions = (CompoundTag)stack.get(ModDataComponentTypes.positions);
        if (positions == null || !positions.contains("Position1") || !positions.contains("Position2")) {
            return null;
        }
        Optional pos1 = NbtUtils.readBlockPos((CompoundTag)positions, (String)"Position1");
        Optional pos2 = NbtUtils.readBlockPos((CompoundTag)positions, (String)"Position2");
        if (pos1.isEmpty() || pos2.isEmpty()) {
            return null;
        }
        int minX = Math.min(((BlockPos)pos1.get()).getX(), ((BlockPos)pos2.get()).getX());
        int minY = Math.min(((BlockPos)pos1.get()).getY(), ((BlockPos)pos2.get()).getY());
        int minZ = Math.min(((BlockPos)pos1.get()).getZ(), ((BlockPos)pos2.get()).getZ());
        int maxX = Math.max(((BlockPos)pos1.get()).getX(), ((BlockPos)pos2.get()).getX());
        int maxY = Math.max(((BlockPos)pos1.get()).getY(), ((BlockPos)pos2.get()).getY());
        int maxZ = Math.max(((BlockPos)pos1.get()).getZ(), ((BlockPos)pos2.get()).getZ());
        return new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static String saveSchematic(Level level, ItemStack stack, StructureSaverSettings settings) {
        StructureTemplate template = new StructureTemplate();
        BoundingBox boundingBox = ItemStructureSaver.getArea(stack);
        if (boundingBox == null) {
            SkyblockBuilder.getLogger().error("No bounding box found for schematic!");
            return null;
        }
        BlockPos origin = new BlockPos(boundingBox.minX(), boundingBox.minY(), boundingBox.minZ());
        BlockPos bounds = new BlockPos(boundingBox.getXSpan(), boundingBox.getYSpan(), boundingBox.getZSpan());
        HashSet toIgnore = Sets.newHashSet((Object[])new Block[]{Blocks.STRUCTURE_VOID});
        if (settings.ignoreAir()) {
            toIgnore.add(Blocks.AIR);
        }
        Set<TemplatesConfig.Spawn> spawnPositions = RandomUtility.fillTemplateFromWorld(template, level, origin, (Vec3i)bounds, true, toIgnore);
        if (settings.saveToConfig()) {
            return ItemStructureSaver.exportToConfig(level, stack, settings, spawnPositions, template);
        }
        if (!spawnPositions.isEmpty()) {
            Path spawns = RandomUtility.getFilePath(SkyPaths.MOD_EXPORTS, settings.name() + "_spawns", "json");
            JsonObject json = TemplateUtil.spawnsAsJson(spawnPositions);
            try {
                Files.writeString(spawns, (CharSequence)SkyblockBuilder.PRETTY_GSON.toJson((JsonElement)json), new OpenOption[0]);
                SkyblockBuilder.getLogger().info("Saved spawns at {}", (Object)spawns.toAbsolutePath());
            }
            catch (IOException e) {
                SkyblockBuilder.getLogger().error("Failed saving {}", (Object)spawns, (Object)e);
                return null;
            }
        }
        Path path = RandomUtility.getFilePath(SkyPaths.MOD_EXPORTS, settings.name(), settings.nbtToSnbt() ? "snbt" : "nbt");
        if (ItemStructureSaver.trySaveTemplate(settings.nbtToSnbt(), template, path)) {
            return null;
        }
        return path.getFileName().toString();
    }

    private static String exportToConfig(Level level, ItemStack stack, StructureSaverSettings settings, Set<TemplatesConfig.Spawn> spawnPositions, StructureTemplate template) {
        StructureSaverSettings.Type type = (StructureSaverSettings.Type)((Object)stack.getOrDefault(ModDataComponentTypes.structureSaverType, (Object)StructureSaverSettings.Type.ISLAND));
        Path configFile = SkyPaths.MOD_CONFIG.resolve("templates.json5");
        try {
            JsonObject config = (JsonObject)SkyblockBuilder.PRETTY_GSON.fromJson(Files.readString(configFile), JsonObject.class);
            Path templatePath = RandomUtility.getFilePath(type.getOutputPath(), settings.name(), settings.nbtToSnbt() ? "snbt" : "nbt");
            if (ItemStructureSaver.trySaveTemplate(settings.nbtToSnbt(), template, templatePath)) {
                return null;
            }
            switch (type) {
                case ISLAND: {
                    JsonObject spawnsJson = TemplateUtil.spawnsAsJson(spawnPositions);
                    ItemStructureSaver.addSpawnsToConfig(config, spawnsJson, settings);
                    String fileName = templatePath.getFileName().toFile().getName();
                    int dot = fileName.lastIndexOf(".");
                    String templateName = fileName.substring(0, dot);
                    JsonObject islandObject = new JsonObject();
                    islandObject.addProperty("name", templateName);
                    islandObject.addProperty("file", fileName);
                    islandObject.add("spawns", (JsonElement)spawnsJson);
                    if (!config.has("templateList")) {
                        config.add("templateList", (JsonElement)new JsonArray());
                    }
                    JsonArray templateList = config.getAsJsonArray("templateList");
                    templateList.add((JsonElement)islandObject);
                    config.add("templateList", (JsonElement)templateList);
                    break;
                }
                case SPREAD: {
                    JsonObject spreadObject = new JsonObject();
                    spreadObject.addProperty("file", templatePath.getFileName().toString());
                    JsonObject offsetObject = new JsonObject();
                    offsetObject.add("min", (JsonElement)WorldUtil.blockPosToJsonArray(BlockPos.ZERO));
                    offsetObject.add("max", (JsonElement)WorldUtil.blockPosToJsonArray(BlockPos.ZERO));
                    spreadObject.add("offset", (JsonElement)offsetObject);
                    spreadObject.addProperty("origin", SpreadInfo.Origin.CENTER.toString());
                    JsonArray spreadsArray = new JsonArray();
                    spreadsArray.add((JsonElement)spreadObject);
                    if (!config.has("spreadReferences")) {
                        config.add("spreadReferences", (JsonElement)new JsonObject());
                    }
                    JsonObject spreadReferences = config.getAsJsonObject("spreadReferences");
                    String name = ItemStructureSaver.getAvailablePropertyName(spreadReferences, settings.name());
                    spreadReferences.add(name, (JsonElement)spreadsArray);
                    config.add("spreadReferences", (JsonElement)spreadReferences);
                }
            }
            Files.writeString(configFile, (CharSequence)SkyblockBuilder.PRETTY_GSON.toJson((JsonElement)config), new OpenOption[0]);
            ConfigManager.reloadConfig(TemplatesConfig.class);
            if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
                ConfigManager.reloadConfig(TemplatesConfig.class);
            }
            return configFile.getFileName().toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to overwrite config " + String.valueOf(configFile.getFileName()));
        }
    }

    private static void addSpawnsToConfig(JsonObject config, JsonObject json, StructureSaverSettings settings) {
        if (!config.has("spawnPointReferences")) {
            config.add("spawnPointReferences", (JsonElement)new JsonObject());
        }
        JsonObject spawns = config.getAsJsonObject("spawnPointReferences");
        String spawnsName = ItemStructureSaver.getAvailablePropertyName(config, settings.name());
        spawns.add(spawnsName, (JsonElement)json);
        config.add("spawnPointReferences", (JsonElement)spawns);
    }

    private static String getAvailablePropertyName(JsonObject config, String name) {
        if (config.has((String)name)) {
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            String formattedDate = dateFormat.format(calendar.getTime());
            name = "exported_at_" + formattedDate;
        }
        return name;
    }

    private static boolean trySaveTemplate(boolean asSnbt, StructureTemplate template, Path path) {
        CompoundTag tag = template.save(new CompoundTag());
        try {
            TemplateUtil.writeTemplate(path, tag, asSnbt);
            SkyblockBuilder.getLogger().info("Saved template at {}", (Object)path.toAbsolutePath());
        }
        catch (IllegalStateException e) {
            SkyblockBuilder.getLogger().error("Failed saving template", (Throwable)e);
            return true;
        }
        return false;
    }

    public static void restorePositions(ItemStack stack) {
        CompoundTag previousPositions = (CompoundTag)stack.get(ModDataComponentTypes.previousPositions);
        if (previousPositions == null) {
            return;
        }
        CompoundTag positions = previousPositions.copy();
        positions.putBoolean("CanSave", true);
        stack.set(ModDataComponentTypes.positions, (Object)positions);
        stack.remove(ModDataComponentTypes.previousPositions);
    }

    public static ItemStack removeComponents(ItemStack stack) {
        CompoundTag positions = (CompoundTag)stack.get(ModDataComponentTypes.positions);
        if (positions == null) {
            return stack;
        }
        CompoundTag previousPositions = positions.copy();
        stack.remove(ModDataComponentTypes.positions);
        stack.set(ModDataComponentTypes.previousPositions, (Object)previousPositions);
        return stack;
    }
}

