/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.compat.heracles;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.melanx.skyblockbuilder.config.common.HeraclesConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.util.WorldUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class SpreadPredicate {
    public static final Codec<SpreadPredicate> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)Codec.either((Codec)Codec.STRING.listOf(), (Codec)Codec.STRING).xmap(either -> (List)either.map(spreads -> spreads, Collections::singletonList), spreads -> spreads.size() == 1 ? Either.right((Object)((String)spreads.getFirst())) : Either.left((Object)spreads)).fieldOf("spreads").forGetter(ins -> ins.spreads)).apply((Applicative)instance, SpreadPredicate::create));
    public static final SpreadPredicate ALWAYS_TRUE = new SpreadPredicate(Collections.emptyList());
    private final List<String> spreads;

    private SpreadPredicate(List<String> spreads) {
        this.spreads = spreads;
    }

    public static SpreadPredicate create(String spread) {
        return SpreadPredicate.create(Collections.singletonList(spread));
    }

    public static SpreadPredicate create(List<String> spreads) {
        if ((spreads = spreads.stream().filter(s -> !s.isEmpty()).toList()).isEmpty()) {
            return ALWAYS_TRUE;
        }
        return new SpreadPredicate(spreads);
    }

    public boolean matches(ServerPlayer player) {
        if (this == ALWAYS_TRUE) {
            return true;
        }
        ServerLevel level = player.serverLevel();
        Team team = SkyblockSavedData.get((Level)level).getTeamFromPlayer((Player)player);
        for (String spread : this.spreads) {
            if (!this.matches(level, team, spread, player.getX(), player.getY(), player.getZ())) continue;
            return true;
        }
        return false;
    }

    public boolean matches(ServerLevel level, Team team, String spread, double x, double y, double z) {
        if (this == ALWAYS_TRUE) {
            return true;
        }
        if (team == null || team.isSpawn() || team.getPlacedSpreads().isEmpty()) {
            return HeraclesConfig.skipNonExistingSpreads;
        }
        Set<Team.PlacedSpread> placedSpreads = team.getPlacedSpreads(spread);
        if (WorldUtil.getConfiguredLevel(level.getServer()) != level) {
            return false;
        }
        for (Team.PlacedSpread placedSpread : placedSpreads) {
            if (!BoundingBox.fromCorners((Vec3i)placedSpread.pos(), (Vec3i)placedSpread.pos().offset((Vec3i)placedSpread.size())).isInside((int)x, (int)y, (int)z)) continue;
            return true;
        }
        return false;
    }

    public List<String> getSpreads() {
        return List.copyOf(this.spreads);
    }
}

