/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.invitation;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.commands.Suggestions;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.CommandUtil;
import de.melanx.skyblockbuilder.util.SkyComponents;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class DeclineCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"decline").then(Commands.argument((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.INVITE_TEAMS).executes(context -> DeclineCommand.declineTeam((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"team"))));
    }

    private static int declineTeam(CommandSourceStack source, String teamName) throws CommandSyntaxException {
        CommandUtil.ValidationResult validationResult = CommandUtil.validateTeamExistence(source, teamName);
        if (validationResult == null) {
            return 0;
        }
        ServerPlayer player = validationResult.player();
        if (!validationResult.data().hasInvites((Player)player)) {
            source.sendFailure((Component)SkyComponents.ERROR_NO_INVITATIONS);
            return 0;
        }
        switch (SkyblockHooks.onDecline(player, validationResult.team())) {
            case DENY: {
                source.sendFailure((Component)SkyComponents.DENIED_DECLINE_INVITATIONS);
                return 0;
            }
            case DEFAULT: {
                if (PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.TEAM_HANDLE_INVITES)) break;
                source.sendFailure((Component)SkyComponents.DISABLED_DECLINE_INVITATIONS);
                return 0;
            }
        }
        if (!validationResult.data().declineInvite(validationResult.team(), (Player)player)) {
            source.sendFailure((Component)SkyComponents.ERROR_DECLINE_INVITATIONS);
            return 0;
        }
        source.sendSuccess(() -> (Component)SkyComponents.SUCCESS_DECLINED_INVITATION.apply(validationResult.team().getName()), true);
        return 1;
    }
}

