/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.client.screens;

import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.client.SizeableCheckbox;
import de.melanx.skyblockbuilder.client.screens.BaseScreen;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.DumpUtil;
import de.melanx.skyblockbuilder.util.SkyComponents;
import java.awt.Color;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.loading.FMLPaths;
import org.moddingx.libx.render.RenderHelper;

public class DumpScreen
extends BaseScreen {
    private static final int CHECKBOX_SIZE = 10;
    private static final int CHECKBOX_X = 10;
    private static final int CHECKBOX_FIRST_Y = 25;
    private static final int TEXT_X = 27;
    private static final int TEXT_FIRST_Y = 27;
    private static final int ROW_OFFSET = 15;
    public MinecraftServer server;
    public SizeableCheckbox includeConfigs;
    public SizeableCheckbox includeTemplates;
    public SizeableCheckbox includeLevelDat;
    public SizeableCheckbox includeLog;
    public SizeableCheckbox includeCrashReport;
    public SizeableCheckbox includeSkyblockBuilderWorldData;
    public SizeableCheckbox generateOnServer;

    public DumpScreen() {
        super(174, DumpScreen.isOpPlayer() ? 172 : 157, (Component)SkyComponents.SCREEN_DUMP_TITLE);
    }

    @Override
    protected void init() {
        super.init();
        int i = 1;
        this.includeConfigs = (SizeableCheckbox)this.addRenderableWidget((GuiEventListener)new SizeableCheckbox(this.x(10), this.y(25), 10, true));
        this.includeTemplates = (SizeableCheckbox)this.addRenderableWidget((GuiEventListener)new SizeableCheckbox(this.x(10), this.y(25 + 15 * i++), 10, true));
        this.includeLevelDat = (SizeableCheckbox)this.addRenderableWidget((GuiEventListener)new SizeableCheckbox(this.x(10), this.y(25 + 15 * i++), 10, true));
        this.includeLog = (SizeableCheckbox)this.addRenderableWidget((GuiEventListener)new SizeableCheckbox(this.x(10), this.y(25 + 15 * i++), 10, true));
        this.includeCrashReport = (SizeableCheckbox)this.addRenderableWidget((GuiEventListener)new SizeableCheckbox(this.x(10), this.y(25 + 15 * i++), 10, true));
        this.includeSkyblockBuilderWorldData = (SizeableCheckbox)this.addRenderableWidget((GuiEventListener)new SizeableCheckbox(this.x(10), this.y(25 + 15 * i++), 10, true));
        this.generateOnServer = (SizeableCheckbox)this.addRenderableWidget((GuiEventListener)new SizeableCheckbox(this.x(10), this.y(25 + 15 * i), 10, false));
        this.generateOnServer.visible = DumpScreen.isOpPlayer();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)SkyComponents.SCREEN_DUMP_BUTTON_CREATE, button -> {
            if (this.generateOnServer.selected()) {
                SkyblockBuilder.getNetwork().createSkyblockDump(this.includeConfigs.selected(), this.includeTemplates.selected(), this.includeLevelDat.selected(), this.includeLog.selected(), this.includeCrashReport.selected(), this.includeSkyblockBuilderWorldData.selected());
            } else {
                Path zip = DumpUtil.createZip(this.includeConfigs.selected(), this.includeTemplates.selected(), this.includeLevelDat.selected(), this.includeLog.selected(), this.includeCrashReport.selected(), this.includeSkyblockBuilderWorldData.selected());
                Minecraft.getInstance().player.sendSystemMessage((Component)SkyComponents.SCREEN_DUMP_SUCCESS.apply(FMLPaths.GAMEDIR.get().relativize(zip).toString()).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, zip.getParent().toString()))));
                Minecraft.getInstance().player.sendSystemMessage((Component)SkyComponents.SCREEN_DUMP_CREATE_ISSUE.append(" ").append(DumpUtil.getIssueUrl()));
            }
            this.onClose();
        }).bounds(this.centeredX(120), this.y(DumpScreen.isOpPlayer() ? 137 : 122), 120, 20).build());
    }

    public void renderBackground(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        RenderHelper.renderGuiBackground((GuiGraphics)guiGraphics, (int)this.x(0), (int)this.y(0), (int)this.getXSize(), (int)this.getYSize());
        guiGraphics.drawString(this.font, this.title, this.centeredX(this.font.width((FormattedText)this.title)), this.y(8), Color.DARK_GRAY.getRGB(), false);
        int i = 1;
        guiGraphics.drawString(this.font, (Component)SkyComponents.SCREEN_DUMP_TEXT_CONFIGS, this.x(27), this.y(27), Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, (Component)SkyComponents.SCREEN_DUMP_TEXT_TEMPLATES, this.x(27), this.y(27 + 15 * i++), Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, (Component)SkyComponents.SCREEN_DUMP_TEXT_LEVEL_DAT, this.x(27), this.y(27 + 15 * i++), Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, (Component)SkyComponents.SCREEN_DUMP_TEXT_LATEST_LOG, this.x(27), this.y(27 + 15 * i++), Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, (Component)SkyComponents.SCREEN_DUMP_TEXT_CRASH_REPORT, this.x(27), this.y(27 + 15 * i++), Color.DARK_GRAY.getRGB(), false);
        guiGraphics.drawString(this.font, (Component)SkyComponents.SCREEN_DUMP_TEXT_DATA_FILE, this.x(27), this.y(27 + 15 * i++), Color.DARK_GRAY.getRGB(), false);
        if (DumpScreen.isOpPlayer()) {
            guiGraphics.drawString(this.font, (Component)SkyComponents.SCREEN_DUMP_TEXT_CREATE_ON_SERVER, this.x(27), this.y(27 + 15 * i), Color.DARK_GRAY.getRGB(), false);
        }
    }

    private static boolean isOpPlayer() {
        return Minecraft.getInstance().player != null && PermissionManager.INSTANCE.mayExecuteOpCommand((Player)Minecraft.getInstance().player);
    }
}

