/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.client.screens;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.client.screens.ChoosePaletteScreen;
import de.melanx.skyblockbuilder.template.ConfiguredTemplate;
import de.melanx.skyblockbuilder.template.TemplateLoader;
import de.melanx.skyblockbuilder.template.TemplateRenderer;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.util.SkyPaths;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.Validate;

public class CustomizeSkyblockScreen
extends Screen {
    private static final ResourceLocation SELECT_PALETTE = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/widget/page_forward.png");
    private final Screen parent;
    private final List<ConfiguredTemplate> templateMap;
    private final BiConsumer<ConfiguredTemplate, Optional<Integer>> applyTemplate;
    private TemplateList list;
    private Button doneButton;
    private ConfiguredTemplate template;

    public CustomizeSkyblockScreen(CreateWorldScreen parent, WorldCreationContext context) {
        super((Component)Component.translatable((String)"generator.skyblockbuilder.skyblock"));
        this.parent = parent;
        TemplateLoader.updateTemplates();
        this.template = TemplateLoader.getConfiguredTemplate();
        this.templateMap = TemplateLoader.getConfiguredTemplates();
        this.applyTemplate = TemplateLoader::setTemplate;
    }

    protected void init() {
        Optional<Object> paletteIndex = Optional.empty();
        if (this.list != null && this.list.getSelected() != null) {
            paletteIndex = ((TemplateList.TemplateEntry)this.list.getSelected()).getPaletteIndex();
        }
        this.list = new TemplateList();
        this.addWidget((GuiEventListener)this.list);
        this.doneButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.applyTemplate.accept(this.template, this.list.getSelected() != null ? ((TemplateList.TemplateEntry)this.list.getSelected()).getPaletteIndex() : Optional.empty());
            this.minecraft.setScreen(this.parent);
        }).pos(this.width / 2 - 155, this.height - 28).size(150, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.minecraft.setScreen(this.parent)).pos(this.width / 2 + 5, this.height - 28).size(150, 20).build());
        if (this.template != null) {
            this.list.setSelected((TemplateList.TemplateEntry)this.list.children().stream().filter(entry -> Objects.equals(entry.template.getTemplate(), this.template.getTemplate())).findFirst().orElse(null));
            if (this.list.getSelected() != null) {
                paletteIndex.ifPresent(((TemplateList.TemplateEntry)this.list.getSelected())::setPaletteIndex);
            } else {
                this.list.setConfiguredStructureRenderer(new TemplateRenderer(this.template.getTemplate(), (float)(this.width - this.list.getRowWidth()) / 2.0f, 0));
            }
        }
    }

    @Nullable
    TemplateList getTemplateList() {
        return this.list;
    }

    private void updateButtonValidity() {
        this.doneButton.active = this.list.getSelected() != null;
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderMenuBackground(guiGraphics);
        this.list.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 8, Color.WHITE.getRGB());
        guiGraphics.drawCenteredString(this.font, (Component)SkyComponents.SCREEN_SELECT_PALETTE, this.width / 2, 28, Color.GRAY.getRGB());
        this.list.renderEntries(guiGraphics, mouseX, mouseY, partialTick);
    }

    class TemplateList
    extends ObjectSelectionList<TemplateEntry> {
        private final transient Map<String, TemplateRenderer> structureCache;
        private TemplateRenderer configuredStructureRenderer;

        public TemplateList() {
            super(Objects.requireNonNull(CustomizeSkyblockScreen.this.minecraft), CustomizeSkyblockScreen.this.width, CustomizeSkyblockScreen.this.height, 37, 40);
            this.structureCache = new HashMap<String, TemplateRenderer>();
            this.configuredStructureRenderer = null;
            AtomicInteger index = new AtomicInteger();
            CustomizeSkyblockScreen.this.templateMap.stream().sorted(Comparator.comparing(ConfiguredTemplate::getName)).forEach(entry -> this.addEntry((AbstractSelectionList.Entry)new TemplateEntry((ConfiguredTemplate)entry, index.getAndIncrement())));
        }

        public boolean isFocused() {
            return CustomizeSkyblockScreen.this.getFocused() == this;
        }

        public void setSelected(@Nullable TemplateEntry entry) {
            if (entry == this.getSelected()) {
                return;
            }
            super.setSelected((AbstractSelectionList.Entry)entry);
            if (entry != null) {
                CustomizeSkyblockScreen.this.template = entry.template;
            }
            CustomizeSkyblockScreen.this.updateButtonValidity();
        }

        public void renderWidget(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            boolean hasSelectedEntry;
            boolean bl = hasSelectedEntry = this.getSelected() != null;
            if (hasSelectedEntry || this.configuredStructureRenderer != null) {
                int size;
                RenderSystem.enableBlend();
                boolean useIcon = hasSelectedEntry && ((TemplateEntry)this.getSelected()).icon != null;
                int n = size = useIcon ? (this.width - this.getRowWidth()) / 3 : (this.width - this.getRowWidth()) / 2;
                if (useIcon) {
                    int iconSize = ((TemplateEntry)this.getSelected()).icon.getPixels().getHeight();
                    int leftCenteredX = (CustomizeSkyblockScreen.this.width - this.getRowWidth()) / 2 / 2 - size / 2;
                    int centeredY = CustomizeSkyblockScreen.this.height / 2 - size / 2;
                    guiGraphics.blit(((TemplateEntry)this.getSelected()).iconLocation, leftCenteredX, centeredY, size, size, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
                } else {
                    TemplateRenderer renderer;
                    if (hasSelectedEntry) {
                        String templateName = ((TemplateEntry)this.getSelected()).name.getString();
                        renderer = this.structureCache.computeIfAbsent(templateName, key -> new TemplateRenderer(((TemplateEntry)this.getSelected()).template.getTemplate(), size));
                    } else {
                        renderer = this.configuredStructureRenderer;
                    }
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().translate(0.0f, 0.0f, 1000.0f);
                    renderer.render(guiGraphics, (int)((float)(CustomizeSkyblockScreen.this.width - this.getRowWidth()) / 2.0f - (float)size / 2.0f), CustomizeSkyblockScreen.this.height / 2);
                    guiGraphics.pose().popPose();
                }
                RenderSystem.disableBlend();
            }
        }

        protected void renderListItems(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        }

        protected void renderEntries(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.renderListItems(guiGraphics, mouseX, mouseY, partialTick);
        }

        public void setConfiguredStructureRenderer(@Nullable TemplateRenderer templateRenderer) {
            this.configuredStructureRenderer = templateRenderer;
        }

        class TemplateEntry
        extends ObjectSelectionList.Entry<TemplateEntry> {
            private final Component name;
            private final Component desc;
            private final ConfiguredTemplate template;
            private final boolean tooLong;
            private final ResourceLocation iconLocation;
            private final int index;
            private File iconFile;
            private final DynamicTexture icon;
            private Optional<Integer> paletteIndex = Optional.empty();

            public TemplateEntry(ConfiguredTemplate template, int index) {
                this.name = template.getNameComponent();
                this.desc = this.shortened(template.getDescriptionComponent());
                this.template = template;
                this.tooLong = !this.desc.getString().equals(template.getDescriptionComponent().getString());
                this.iconLocation = SkyblockBuilder.getInstance().resource(Util.sanitizeName((String)template.getName(), ResourceLocation::validPathChar) + "/icon");
                this.index = index;
                this.iconFile = SkyPaths.ICONS_DIR.resolve(template.getName().toLowerCase(Locale.ROOT) + ".png").toFile();
                if (!this.iconFile.isFile()) {
                    this.iconFile = null;
                }
                this.icon = this.loadIcon();
            }

            public void render(@Nonnull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                guiGraphics.drawString(CustomizeSkyblockScreen.this.font, this.name, left + 5, top + 7, Color.WHITE.getRGB());
                guiGraphics.drawString(CustomizeSkyblockScreen.this.font, this.desc, left + 5, top + 22, Color.GRAY.getRGB());
                if (this.canSelectPalette()) {
                    int textureX = left + width - 28;
                    int textureY = top + 1;
                    guiGraphics.blit(SELECT_PALETTE, textureX, textureY, 0.0f, 0.0f, 23, 13, 23, 13);
                    if (this.isMouseOverPaletteSelection(textureX, textureY, mouseX, mouseY)) {
                        guiGraphics.renderTooltip(CustomizeSkyblockScreen.this.font, (Component)SkyComponents.SCREEN_SELECT_PALETTE, mouseX, mouseY);
                    }
                }
                if (isMouseOver && this.tooLong) {
                    guiGraphics.renderTooltip(CustomizeSkyblockScreen.this.font, this.template.getDescriptionComponent(), mouseX, mouseY);
                }
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    if (this.canSelectPalette() && this.isMouseOverPaletteSelection(TemplateList.this.getRowLeft() + TemplateList.this.getRowWidth() - 28, TemplateList.this.getRowTop(this.index) + 1, mouseX, mouseY)) {
                        Minecraft.getInstance().pushGuiLayer((Screen)new ChoosePaletteScreen(this.template, this::setPaletteIndex, this::resetPaletteIndex));
                    }
                    TemplateList.this.setSelected(this);
                    return true;
                }
                return false;
            }

            public boolean isMouseOver(double mouseX, double mouseY) {
                return super.isMouseOver(mouseX, mouseY);
            }

            private boolean canSelectPalette() {
                return this.template.getTemplate().palettes.size() > 1 && this.template.allowPaletteSelection();
            }

            private boolean isMouseOverPaletteSelection(int textureX, int textureY, double mouseX, double mouseY) {
                if (!this.canSelectPalette()) {
                    return false;
                }
                return mouseX >= (double)textureX && mouseX <= (double)(textureX + 23) && mouseY >= (double)textureY && mouseY <= (double)(textureY + 13);
            }

            @Nonnull
            public Component getNarration() {
                return this.name;
            }

            public void resetPaletteIndex() {
                this.paletteIndex = Optional.empty();
                TemplateList.this.structureCache.remove(this.name.getString());
            }

            public void setPaletteIndex(int index) {
                this.paletteIndex = Optional.of(index);
                TemplateList.this.structureCache.put(this.name.getString(), new TemplateRenderer(this.template.getTemplate(), (float)(TemplateList.this.width - TemplateList.this.getRowWidth()) / 2.0f, index));
            }

            public Optional<Integer> getPaletteIndex() {
                return this.paletteIndex;
            }

            private DynamicTexture loadIcon() {
                if (this.iconFile != null && this.iconFile.isFile()) {
                    try {
                        DynamicTexture texture;
                        try (FileInputStream in = new FileInputStream(this.iconFile);){
                            NativeImage image = NativeImage.read((InputStream)in);
                            Validate.validState((image.getWidth() == image.getHeight() ? 1 : 0) != 0, (String)"Height and width must be equal.", (Object[])new Object[0]);
                            DynamicTexture tempTexture = new DynamicTexture(image);
                            Minecraft.getInstance().textureManager.register(this.iconLocation, (AbstractTexture)tempTexture);
                            texture = tempTexture;
                        }
                        return texture;
                    }
                    catch (Throwable throwable) {
                        SkyblockBuilder.getLogger().error("Invalid icon for template {}", (Object)this.template.getName(), (Object)throwable);
                        return null;
                    }
                }
                Minecraft.getInstance().textureManager.release(this.iconLocation);
                return null;
            }

            private Component shortened(Component text) {
                String string = text.getString();
                String shorten = RandomUtility.shorten(Minecraft.getInstance().font, string, 210);
                return Component.literal((String)shorten);
            }
        }
    }
}

