/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.client.screens;

import de.melanx.skyblockbuilder.template.ConfiguredTemplate;
import de.melanx.skyblockbuilder.template.TemplateRenderer;
import de.melanx.skyblockbuilder.util.SkyComponents;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class ChoosePaletteScreen
extends Screen {
    private static final int BUTTON_SIZE = 20;
    private static final int BUTTON_STEP = 25;
    private final ConfiguredTemplate template;
    private final OnApply applyIndex;
    private final OnReset resetIndex;
    private int paletteIndex = 0;
    private final transient Map<Integer, TemplateRenderer> structureCache = new HashMap<Integer, TemplateRenderer>();
    private int rows = 1;
    private int structureRenderSize;

    public ChoosePaletteScreen(ConfiguredTemplate template, OnApply onApply, OnReset onReset) {
        super((Component)SkyComponents.SCREEN_SELECT_PALETTE);
        this.template = template;
        this.applyIndex = onApply;
        this.resetIndex = onReset;
    }

    protected void init() {
        super.init();
        assert (this.minecraft != null);
        this.buildPaletteButtons();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.applyIndex.onApply(this.paletteIndex);
            this.minecraft.popGuiLayer();
        }).pos(this.width / 2 - 155, this.height - 28).size(150, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> {
            this.resetIndex.onReset();
            this.minecraft.popGuiLayer();
        }).pos(this.width / 2 + 5, this.height - 28).size(150, 20).build());
        this.structureRenderSize = (int)((double)this.height - (double)this.height * 0.1 - (double)((this.rows - 1) * 50));
    }

    private void buildPaletteButtons() {
        int buttonsInRow;
        int rowTotalWidth;
        int n = this.template.getTemplate().palettes.size();
        int rows = 1;
        while ((rowTotalWidth = ((buttonsInRow = (int)Math.ceil((double)n / (double)rows)) - 1) * 25 + 20) > this.width) {
            ++rows;
        }
        this.rows = rows;
        int baseCount = n / rows;
        int extra = n % rows;
        int paletteIndex = 0;
        for (int i = 0; i < rows; ++i) {
            int buttonsThisRow = rows - i <= extra ? baseCount + 1 : baseCount;
            int rowTotalWidth2 = (buttonsThisRow - 1) * 25 + 20;
            int startX = (this.width - rowTotalWidth2) / 2;
            int y = this.height - 60 - (rows - 1 - i) * 25;
            for (int j = 0; j < buttonsThisRow; ++j) {
                int currentPaletteIndex = paletteIndex++;
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)String.valueOf(currentPaletteIndex + 1)), button -> this.updatePalette(currentPaletteIndex)).pos(startX + j * 25, y).size(20, 20).build());
            }
        }
    }

    private void updatePalette(int paletteIndex) {
        this.paletteIndex = paletteIndex;
    }

    public void resize(@Nonnull Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        this.structureCache.forEach((i, renderer) -> renderer.setSize(this.structureRenderSize));
    }

    public void renderBackground(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.structureCache.computeIfAbsent(this.paletteIndex, key -> new TemplateRenderer(this.template.getTemplate(), this.structureRenderSize, this.paletteIndex)).render(guiGraphics, this.width / 2, this.structureRenderSize / 2 + (int)((double)this.height * 0.05));
    }

    @FunctionalInterface
    public static interface OnApply {
        public void onApply(int var1);
    }

    @FunctionalInterface
    public static interface OnReset {
        public void onReset();
    }
}

