/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.client;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Lifecycle;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerLinks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.Difficulty;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.network.connection.ConnectionType;
import net.neoforged.neoforge.registries.callback.RegistryCallback;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import org.jetbrains.annotations.Nullable;

public class FakeLevel
extends ClientLevel {
    private static FakeLevel instance;
    private static final CommonListenerCookie FAKE_LISTENER_COOKIE;

    public FakeLevel() {
        super(FakeLevel.fakeClientPacketListener(), new ClientLevel.ClientLevelData(Difficulty.EASY, false, true), Level.OVERWORLD, new FakeHolder<DimensionType>(FakeLevel.fakeDimensionType()), 0, 0, () -> null, new LevelRenderer(Minecraft.getInstance(), Minecraft.getInstance().getEntityRenderDispatcher(), Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().renderBuffers()), false, 0L);
    }

    public static FakeLevel getInstance() {
        if (instance == null) {
            instance = new FakeLevel();
        }
        return instance;
    }

    private static ClientPacketListener fakeClientPacketListener() {
        return new ClientPacketListener(Minecraft.getInstance(), new Connection(PacketFlow.CLIENTBOUND), FAKE_LISTENER_COOKIE){

            @Nonnull
            public RegistryAccess.Frozen registryAccess() {
                return FakeRegistry.INSTANCE;
            }
        };
    }

    private static DimensionType fakeDimensionType() {
        return new DimensionType(OptionalLong.empty(), true, false, false, false, 1.0, false, false, 0, 256, 256, BlockTags.INFINIBURN_OVERWORLD, BuiltinDimensionTypes.OVERWORLD_EFFECTS, 1.0f, new DimensionType.MonsterSettings(false, false, (IntProvider)ConstantInt.ZERO, 0));
    }

    static {
        FAKE_LISTENER_COOKIE = new CommonListenerCookie(Minecraft.getInstance().getGameProfile(), Minecraft.getInstance().getTelemetryManager().createWorldSessionManager(false, null, null), (RegistryAccess.Frozen)FakeRegistry.INSTANCE, FeatureFlags.DEFAULT_FLAGS, null, null, null, Map.of(), null, false, Map.of(), ServerLinks.EMPTY, ConnectionType.OTHER);
    }

    public record FakeHolder<T>(T value) implements Holder<T>
    {
        public boolean isBound() {
            return false;
        }

        public boolean is(@Nonnull ResourceLocation location) {
            return false;
        }

        public boolean is(@Nonnull ResourceKey<T> resourceKey) {
            return false;
        }

        public boolean is(@Nonnull Predicate<ResourceKey<T>> predicate) {
            return false;
        }

        public boolean is(@Nonnull TagKey<T> tagKey) {
            return false;
        }

        public boolean is(@Nonnull Holder<T> holder) {
            return false;
        }

        @Nonnull
        public Stream<TagKey<T>> tags() {
            return Stream.of(new TagKey[0]);
        }

        @Nonnull
        public Either<ResourceKey<T>, T> unwrap() {
            return Either.right(this.value);
        }

        @Nonnull
        public Optional<ResourceKey<T>> unwrapKey() {
            Constructor constructor = ObfuscationReflectionHelper.findConstructor(ResourceKey.class, (Class[])new Class[]{ResourceLocation.class, ResourceLocation.class});
            constructor.setAccessible(true);
            try {
                return Optional.of((ResourceKey)constructor.newInstance(ResourceLocation.tryParse((String)""), ResourceLocation.tryParse((String)"")));
            }
            catch (Exception e) {
                SkyblockBuilder.getLogger().error("Error in fake level: ", (Throwable)e);
                return Optional.empty();
            }
        }

        @Nonnull
        public Holder.Kind kind() {
            return Holder.Kind.DIRECT;
        }

        public boolean canSerializeIn(@Nonnull HolderOwner<T> owner) {
            return false;
        }
    }

    private static class FakeRegistry
    implements RegistryAccess.Frozen {
        private static final FakeRegistry INSTANCE = new FakeRegistry();

        private FakeRegistry() {
        }

        @Nonnull
        public <E> Optional<Registry<E>> registry(@Nonnull ResourceKey<? extends Registry<? extends E>> registryKey) {
            return Optional.empty();
        }

        @Nonnull
        public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(@Nonnull ResourceKey<? extends Registry<? extends T>> registryKey) {
            return Optional.empty();
        }

        @Nonnull
        public <E> Registry<E> registryOrThrow(@Nonnull ResourceKey<? extends Registry<? extends E>> registryKey) {
            return new FakeRegistryObject();
        }

        public Stream<RegistryAccess.RegistryEntry<?>> registries() {
            return null;
        }

        public RegistryAccess.Frozen freeze() {
            return null;
        }

        public Lifecycle allRegistriesLifecycle() {
            return null;
        }
    }

    private static class FakeRegistryObject<T>
    implements Registry<T> {
        private FakeRegistryObject() {
        }

        public Holder.Reference<T> getHolderOrThrow(ResourceKey<T> key) {
            return null;
        }

        public ResourceKey<? extends Registry<T>> key() {
            return null;
        }

        @javax.annotation.Nullable
        public ResourceLocation getKey(T value) {
            return null;
        }

        public Optional<ResourceKey<T>> getResourceKey(T value) {
            return Optional.empty();
        }

        public int getId(@javax.annotation.Nullable T value) {
            return 0;
        }

        @javax.annotation.Nullable
        public T byId(int id) {
            return null;
        }

        public int size() {
            return 0;
        }

        @javax.annotation.Nullable
        public T get(@javax.annotation.Nullable ResourceKey<T> key) {
            return null;
        }

        @javax.annotation.Nullable
        public T get(@javax.annotation.Nullable ResourceLocation name) {
            return null;
        }

        public Optional<RegistrationInfo> registrationInfo(ResourceKey<T> key) {
            return Optional.empty();
        }

        public Lifecycle registryLifecycle() {
            return null;
        }

        public Optional<Holder.Reference<T>> getAny() {
            return Optional.empty();
        }

        public Set<ResourceLocation> keySet() {
            return null;
        }

        public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
            return null;
        }

        public Set<ResourceKey<T>> registryKeySet() {
            return null;
        }

        public Optional<Holder.Reference<T>> getRandom(RandomSource random) {
            return Optional.empty();
        }

        public boolean containsKey(ResourceLocation name) {
            return false;
        }

        public boolean containsKey(ResourceKey<T> key) {
            return false;
        }

        public Registry<T> freeze() {
            return null;
        }

        public Holder.Reference<T> createIntrusiveHolder(T value) {
            return null;
        }

        public Optional<Holder.Reference<T>> getHolder(int id) {
            return Optional.empty();
        }

        public Optional<Holder.Reference<T>> getHolder(ResourceLocation location) {
            return Optional.empty();
        }

        public Optional<Holder.Reference<T>> getHolder(ResourceKey<T> key) {
            return Optional.empty();
        }

        public Holder<T> wrapAsHolder(T value) {
            return null;
        }

        public Stream<Holder.Reference<T>> holders() {
            return null;
        }

        public Optional<HolderSet.Named<T>> getTag(TagKey<T> key) {
            return Optional.empty();
        }

        public HolderSet.Named<T> getOrCreateTag(TagKey<T> key) {
            return null;
        }

        public Stream<Pair<TagKey<T>, HolderSet.Named<T>>> getTags() {
            return null;
        }

        public Stream<TagKey<T>> getTagNames() {
            return null;
        }

        public void resetTags() {
        }

        public void bindTags(Map<TagKey<T>, List<Holder<T>>> tagMap) {
        }

        public HolderOwner<T> holderOwner() {
            return null;
        }

        public HolderLookup.RegistryLookup<T> asLookup() {
            return null;
        }

        public Iterator<T> iterator() {
            return null;
        }

        public boolean doesSync() {
            return false;
        }

        public int getMaxId() {
            return 0;
        }

        public void addCallback(RegistryCallback<T> callback) {
        }

        public void addAlias(ResourceLocation from, ResourceLocation to) {
        }

        public ResourceLocation resolve(ResourceLocation name) {
            return null;
        }

        public ResourceKey<T> resolve(ResourceKey<T> key) {
            return null;
        }

        public int getId(ResourceKey<T> key) {
            return 0;
        }

        public int getId(ResourceLocation name) {
            return 0;
        }

        public boolean containsValue(T value) {
            return false;
        }

        @Nullable
        public <A> A getData(DataMapType<T, A> type, ResourceKey<T> key) {
            return null;
        }

        public <A> Map<ResourceKey<T>, A> getDataMap(DataMapType<T, A> type) {
            return Map.of();
        }
    }
}

