/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.world.presets;

import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.config.common.DimensionsConfig;
import de.melanx.skyblockbuilder.config.common.WorldConfig;
import de.melanx.skyblockbuilder.datagen.SkyblockBiomeParameters;
import de.melanx.skyblockbuilder.util.BiomeSourceConverter;
import de.melanx.skyblockbuilder.world.biomesource.CustomMultiNoiseBiomeSource;
import de.melanx.skyblockbuilder.world.biomesource.SkyBiomeSource;
import de.melanx.skyblockbuilder.world.chunkgenerators.SkyblockEndChunkGenerator;
import de.melanx.skyblockbuilder.world.chunkgenerators.SkyblockNoiseBasedChunkGenerator;
import de.melanx.skyblockbuilder.world.flat.FlatLayers;
import de.melanx.skyblockbuilder.world.presets.BiomeParametersPreset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterLists;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import org.moddingx.libx.util.lazy.LazyValue;

public class SkyblockPreset
extends WorldPreset {
    public static final ResourceKey<WorldPreset> KEY = ResourceKey.create((ResourceKey)Registries.WORLD_PRESET, (ResourceLocation)SkyblockBuilder.getInstance().resource("skyblock"));
    private final LazyValue<WorldPreset> actualPreset = new LazyValue(() -> new WorldPreset(SkyblockPreset.dimensions(dimensionTypes, noises, noiseGeneratorSettings, (HolderLookup<Biome>)biomes)));
    private final HolderLookup.RegistryLookup<Biome> biomes;

    public SkyblockPreset(HolderGetter<DimensionType> dimensionTypes, HolderGetter<MultiNoiseBiomeSourceParameterList> noises, HolderGetter<NoiseGeneratorSettings> noiseGeneratorSettings, HolderLookup.RegistryLookup<Biome> biomes) {
        super(Map.of());
        this.biomes = biomes;
        BiomeParametersPreset.init(biomes);
    }

    public HolderLookup.RegistryLookup<Biome> getBiomes() {
        return this.biomes;
    }

    @Nonnull
    public WorldDimensions createWorldDimensions() {
        return ((WorldPreset)this.actualPreset.get()).createWorldDimensions();
    }

    @Nonnull
    public Optional<LevelStem> overworld() {
        return ((WorldPreset)this.actualPreset.get()).overworld();
    }

    public static Map<ResourceKey<LevelStem>, LevelStem> dimensions(HolderGetter<DimensionType> dimensionTypes, HolderGetter<MultiNoiseBiomeSourceParameterList> noises, HolderGetter<NoiseGeneratorSettings> noiseGeneratorSettings, HolderLookup<Biome> biomes) {
        return Map.of(LevelStem.OVERWORLD, new LevelStem((Holder)dimensionTypes.getOrThrow(BuiltinDimensionTypes.OVERWORLD), SkyblockPreset.configuredOverworldChunkGenerator(noises, noiseGeneratorSettings, biomes)), LevelStem.NETHER, new LevelStem((Holder)dimensionTypes.getOrThrow(BuiltinDimensionTypes.NETHER), DimensionsConfig.Nether.isCustom ? SkyblockPreset.netherChunkGenerator(noises, noiseGeneratorSettings, biomes) : SkyblockPreset.defaultNetherGenerator(noises, noiseGeneratorSettings)), LevelStem.END, new LevelStem((Holder)dimensionTypes.getOrThrow(BuiltinDimensionTypes.END), DimensionsConfig.End.isCustom ? SkyblockPreset.endChunkGenerator(noiseGeneratorSettings, biomes) : SkyblockPreset.defaultEndGenerator(noiseGeneratorSettings, biomes)));
    }

    public static ChunkGenerator configuredOverworldChunkGenerator(HolderGetter<MultiNoiseBiomeSourceParameterList> noises, HolderGetter<NoiseGeneratorSettings> noiseGeneratorSettings, HolderLookup<Biome> biomes) {
        return DimensionsConfig.Overworld.isCustom ? SkyblockPreset.overworldChunkGenerator(noises, noiseGeneratorSettings, biomes) : new NoiseBasedChunkGenerator((BiomeSource)MultiNoiseBiomeSource.createFromPreset((Holder)noises.getOrThrow(MultiNoiseBiomeSourceParameterLists.OVERWORLD)), (Holder)noiseGeneratorSettings.getOrThrow(NoiseGeneratorSettings.OVERWORLD));
    }

    public static ChunkGenerator overworldChunkGenerator(HolderGetter<MultiNoiseBiomeSourceParameterList> noises, HolderGetter<NoiseGeneratorSettings> noiseGeneratorSettings, HolderLookup<Biome> biomes) {
        CustomMultiNoiseBiomeSource biomeSource = new CustomMultiNoiseBiomeSource((Holder<MultiNoiseBiomeSourceParameterList>)noises.getOrThrow(SkyblockBiomeParameters.KEY));
        Holder.Reference settings = noiseGeneratorSettings.getOrThrow(NoiseGeneratorSettings.OVERWORLD);
        biomeSource = SkyblockPreset.convertBiomeSource(biomeSource, biomes, DimensionsConfig.Overworld.centeredBiomes);
        return new SkyblockNoiseBasedChunkGenerator((BiomeSource)biomeSource, (Holder<NoiseGeneratorSettings>)settings, (ResourceKey<Level>)Level.OVERWORLD, SkyblockPreset.getLayers((ResourceKey<Level>)Level.OVERWORLD));
    }

    private static ChunkGenerator netherChunkGenerator(HolderGetter<MultiNoiseBiomeSourceParameterList> noises, HolderGetter<NoiseGeneratorSettings> noiseGeneratorSettings, HolderLookup<Biome> biomes) {
        BiomeSource biomeSource = BiomeSourceConverter.customBiomeSource((ResourceKey<Level>)Level.NETHER, (BiomeSource)MultiNoiseBiomeSource.createFromPreset((Holder)noises.getOrThrow(MultiNoiseBiomeSourceParameterLists.NETHER)), biomes);
        Holder.Reference settings = noiseGeneratorSettings.getOrThrow(NoiseGeneratorSettings.NETHER);
        biomeSource = SkyblockPreset.convertBiomeSource((MultiNoiseBiomeSource)biomeSource, biomes, DimensionsConfig.Nether.centeredBiomes);
        return new SkyblockNoiseBasedChunkGenerator(biomeSource, (Holder<NoiseGeneratorSettings>)settings, (ResourceKey<Level>)Level.NETHER, SkyblockPreset.getLayers((ResourceKey<Level>)Level.NETHER));
    }

    private static ChunkGenerator endChunkGenerator(HolderGetter<NoiseGeneratorSettings> noiseGeneratorSettings, HolderLookup<Biome> biomes) {
        TheEndBiomeSource biomeSource = (TheEndBiomeSource)BiomeSourceConverter.customBiomeSource((ResourceKey<Level>)Level.END, (BiomeSource)TheEndBiomeSource.create(biomes), biomes);
        Holder.Reference settings = noiseGeneratorSettings.getOrThrow(NoiseGeneratorSettings.END);
        return new SkyblockEndChunkGenerator((BiomeSource)biomeSource, (Holder<NoiseGeneratorSettings>)settings, (ResourceKey<Level>)Level.END, SkyblockPreset.getLayers((ResourceKey<Level>)Level.END));
    }

    public static FlatLayers getLayers(ResourceKey<Level> levelKey) {
        return WorldConfig.surface ? WorldConfig.surfaceSettings.getOrDefault(levelKey.location().toString(), FlatLayers.EMPTY) : FlatLayers.EMPTY;
    }

    private static BiomeSource convertBiomeSource(MultiNoiseBiomeSource biomeSource, HolderLookup<Biome> biomes, List<DimensionsConfig.UnregisteredCenterBiome> unregisteredCenterBiomes) {
        if (unregisteredCenterBiomes.isEmpty()) {
            return biomeSource;
        }
        ArrayList<SkyBiomeSource.CenterBiome> centerBiomes = new ArrayList<SkyBiomeSource.CenterBiome>();
        unregisteredCenterBiomes.forEach(biomeConfig -> {
            ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)biomeConfig.id());
            Optional<Holder.Reference> optionalHolder = biomes.get(resourceKey);
            if (optionalHolder.isEmpty()) {
                SkyblockBuilder.getLogger().error("Could not find biome {} for center biome {}. Use minecraft:plains as fallback.", (Object)resourceKey, (Object)biomeConfig.id());
                optionalHolder = Optional.of(biomes.getOrThrow(Biomes.PLAINS));
            }
            centerBiomes.add(new SkyBiomeSource.CenterBiome((Holder<Biome>)((Holder)optionalHolder.get()), biomeConfig.radius()));
        });
        return new SkyBiomeSource(centerBiomes, biomeSource);
    }

    private static ChunkGenerator defaultNetherGenerator(HolderGetter<MultiNoiseBiomeSourceParameterList> noises, HolderGetter<NoiseGeneratorSettings> noiseGeneratorSettings) {
        MultiNoiseBiomeSource biomeSource = MultiNoiseBiomeSource.createFromPreset((Holder)noises.getOrThrow(MultiNoiseBiomeSourceParameterLists.NETHER));
        Holder.Reference settings = noiseGeneratorSettings.getOrThrow(NoiseGeneratorSettings.NETHER);
        return new NoiseBasedChunkGenerator((BiomeSource)biomeSource, (Holder)settings);
    }

    private static ChunkGenerator defaultEndGenerator(HolderGetter<NoiseGeneratorSettings> noiseGeneratorSettings, HolderGetter<Biome> biomes) {
        Holder.Reference settings = noiseGeneratorSettings.getOrThrow(NoiseGeneratorSettings.END);
        TheEndBiomeSource biomeSource = TheEndBiomeSource.create(biomes);
        return new NoiseBasedChunkGenerator((BiomeSource)biomeSource, (Holder)settings);
    }
}

