/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.world.IslandPos;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import org.apache.commons.io.IOUtils;

public class TemplateUtil {
    public static final StructurePlaceSettings STRUCTURE_PLACE_SETTINGS = new StructurePlaceSettings().setKnownShape(true).setLiquidSettings(LiquidSettings.IGNORE_WATERLOGGING);

    public static JsonObject possibleSpawnsAsJson(@Nonnull Team team) {
        return TemplateUtil.spawnsAsJson(team.getIsland(), team.getPossibleSpawns());
    }

    public static JsonObject defaultSpawnsAsJson(@Nonnull Team team) {
        return TemplateUtil.spawnsAsJson(team.getIsland(), team.getDefaultPossibleSpawns());
    }

    public static JsonObject spawnsAsJson(Set<TemplatesConfig.Spawn> spawns) {
        JsonArray north = new JsonArray();
        JsonArray east = new JsonArray();
        JsonArray south = new JsonArray();
        JsonArray west = new JsonArray();
        for (TemplatesConfig.Spawn spawn : spawns) {
            JsonArray position = new JsonArray();
            position.add((Number)spawn.pos().getX());
            position.add((Number)spawn.pos().getY());
            position.add((Number)spawn.pos().getZ());
            switch (spawn.direction()) {
                case NORTH: {
                    north.add((JsonElement)position);
                    break;
                }
                case EAST: {
                    east.add((JsonElement)position);
                    break;
                }
                case SOUTH: {
                    south.add((JsonElement)position);
                    break;
                }
                case WEST: {
                    west.add((JsonElement)position);
                }
            }
        }
        JsonObject json = new JsonObject();
        json.add("north", (JsonElement)north);
        json.add("east", (JsonElement)east);
        json.add("south", (JsonElement)south);
        json.add("west", (JsonElement)west);
        return json;
    }

    public static JsonObject spawnsAsJson(IslandPos islandPos, Set<TemplatesConfig.Spawn> possibleSpawns) {
        JsonArray north = new JsonArray();
        JsonArray east = new JsonArray();
        JsonArray south = new JsonArray();
        JsonArray west = new JsonArray();
        for (TemplatesConfig.Spawn spawn : possibleSpawns) {
            JsonArray position = new JsonArray();
            position.add((Number)(spawn.pos().getX() + islandPos.getCenter().getX()));
            position.add((Number)(spawn.pos().getY() - islandPos.getCenter().getY()));
            position.add((Number)(spawn.pos().getZ() + islandPos.getCenter().getZ()));
            switch (spawn.direction()) {
                case NORTH: {
                    north.add((JsonElement)position);
                    break;
                }
                case EAST: {
                    east.add((JsonElement)position);
                    break;
                }
                case SOUTH: {
                    south.add((JsonElement)position);
                    break;
                }
                case WEST: {
                    west.add((JsonElement)position);
                }
            }
        }
        JsonObject json = new JsonObject();
        json.add("north", (JsonElement)north);
        json.add("east", (JsonElement)east);
        json.add("south", (JsonElement)south);
        json.add("west", (JsonElement)west);
        return json;
    }

    public static void writeTemplate(Path path, CompoundTag template, boolean asSnbt) {
        try {
            if (asSnbt) {
                String snbt = NbtUtils.structureToSnbt((CompoundTag)template);
                Files.writeString(path, (CharSequence)snbt, new OpenOption[0]);
            } else {
                OutputStream outputStream = Files.newOutputStream(path, StandardOpenOption.CREATE);
                NbtIo.writeCompressed((CompoundTag)template, (OutputStream)outputStream);
                outputStream.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create template file", e);
        }
    }

    public static CompoundTag readTemplate(Path path) throws IOException, CommandSyntaxException {
        return TemplateUtil.readTemplate(path, path.toString().endsWith(".snbt"));
    }

    public static CompoundTag readTemplate(Path path, boolean snbt) throws IOException, CommandSyntaxException {
        if (snbt) {
            return NbtUtils.snbtToStructure((String)IOUtils.toString((Reader)Files.newBufferedReader(path)));
        }
        return NbtIo.readCompressed((Path)path, (NbtAccounter)NbtAccounter.unlimitedHeap());
    }
}

