/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.invitation;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.events.SkyblockInvitationEvent;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.util.WorldUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class InviteCommand {
    public static final HoverEvent COPY_TEXT = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"chat.copy.click"));

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"invite").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> InviteCommand.invitePlayer((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"))));
    }

    private static int invitePlayer(CommandSourceStack source, ServerPlayer invitePlayer) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.getLevel();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        ServerPlayer player = source.getPlayerOrException();
        Team team = data.getTeamFromPlayer((Player)player);
        if (team == null) {
            source.sendFailure((Component)SkyComponents.ERROR_USER_HAS_NO_TEAM);
            return 0;
        }
        Team invitedPlayersTeam = data.getTeamFromPlayer((Player)invitePlayer);
        if (invitedPlayersTeam != null) {
            source.sendFailure((Component)SkyComponents.ERROR_PLAYER_HAS_TEAM.apply(invitePlayer.getName().getString()));
            return 0;
        }
        if (data.hasInviteFrom(team, (Player)invitePlayer)) {
            source.sendFailure((Component)SkyComponents.ERROR_PLAYER_ALREADY_INVITED);
            return 0;
        }
        SkyblockInvitationEvent.Invite event = SkyblockHooks.onInvite(invitePlayer, team, player);
        switch (event.getResult()) {
            case DENY: {
                source.sendFailure((Component)SkyComponents.DENIED_INVITE_PLAYER);
                return 0;
            }
            case DEFAULT: {
                if (PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.TEAM_HANDLE_INVITES)) break;
                source.sendFailure((Component)SkyComponents.DISABLED_SEND_INVITATIONS);
                return 0;
            }
        }
        data.addInvite(team, (Player)event.getInvitor(), (Player)invitePlayer);
        MutableComponent invite = SkyComponents.INFO_INVITED_TO_TEAM0.apply(player.getDisplayName().getString(), team.getName()).withStyle(ChatFormatting.GOLD);
        invite.append((Component)Component.literal((String)("/skyblock accept \"" + team.getName() + "\"")).setStyle(Style.EMPTY.withHoverEvent(COPY_TEXT).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/skyblock accept \"" + team.getName() + "\"")).applyFormat(ChatFormatting.UNDERLINE).applyFormat(ChatFormatting.GOLD)));
        invite.append((Component)SkyComponents.INFO_INVITED_TO_TEAM1.withStyle(ChatFormatting.GOLD));
        invitePlayer.displayClientMessage((Component)invite, false);
        return 1;
    }
}

