/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.world.presets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.config.common.WorldConfig;
import de.melanx.skyblockbuilder.util.WorldUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import org.moddingx.libx.util.data.ResourceList;

public class BiomeParametersPreset
implements MultiNoiseBiomeSourceParameterList.Preset.SourceProvider {
    public static final MultiNoiseBiomeSourceParameterList.Preset FILTERED_OVERWORLD = new MultiNoiseBiomeSourceParameterList.Preset(SkyblockBuilder.getInstance().resource("filtered_overworld"), (MultiNoiseBiomeSourceParameterList.Preset.SourceProvider)new BiomeParametersPreset());
    private static HolderLookup.RegistryLookup<Biome> BIOMES;

    public static void init(HolderLookup.RegistryLookup<Biome> biomes) {
        BIOMES = biomes;
    }

    @Nonnull
    public <T> Climate.ParameterList<T> apply(@Nonnull Function<ResourceKey<Biome>, T> valueGetter) {
        return this.generateOverworldBiomes(valueGetter);
    }

    private <T> Climate.ParameterList<T> generateOverworldBiomes(Function<ResourceKey<Biome>, T> valueGetter) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ResourceList resourceList = WorldConfig.biomes.getOrDefault(Level.OVERWORLD.location().toString(), ResourceList.DENY_LIST);
        HashSet addedBiomes = new HashSet();
        Consumer<Pair> consumer = p -> {
            if (resourceList.test(((ResourceKey)p.getSecond()).location())) {
                builder.add((Object)p.mapSecond(valueGetter));
                addedBiomes.add((ResourceKey)p.getSecond());
            }
        };
        new OverworldBiomeBuilder().addBiomes(consumer);
        if (BIOMES == null) {
            return new Climate.ParameterList((List)builder.build());
        }
        BIOMES.listElementIds().forEach(biomeResourceKey -> {
            Optional biomeReference = BIOMES.get(biomeResourceKey);
            if (!addedBiomes.contains(biomeResourceKey) && biomeReference.isPresent() && resourceList.test(biomeResourceKey.location())) {
                builder.add((Object)Pair.of((Object)WorldUtil.pointFor((ResourceKey<Biome>)biomeResourceKey), valueGetter.apply((ResourceKey<Biome>)biomeResourceKey)));
            }
        });
        return new Climate.ParameterList((List)builder.build());
    }
}

