/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.util;

import com.google.gson.JsonArray;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.config.SpawnSettings;
import de.melanx.skyblockbuilder.config.common.DimensionsConfig;
import de.melanx.skyblockbuilder.config.common.PermissionsConfig;
import de.melanx.skyblockbuilder.config.common.SpawnConfig;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.config.common.WorldConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.registration.ModBlockTags;
import de.melanx.skyblockbuilder.util.PositionHelper;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.world.chunkgenerators.SkyblockEndChunkGenerator;
import de.melanx.skyblockbuilder.world.chunkgenerators.SkyblockNoiseBasedChunkGenerator;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;

public class WorldUtil {
    public static void teleportToIsland(ServerPlayer player, Team team) {
        Team playersTeam;
        MinecraftServer server = player.getServer();
        if (WorldConfig.leaveToOverworld && team.isSpawn() && ((playersTeam = SkyblockSavedData.get((Level)player.serverLevel()).getTeamFromPlayer((Player)player)) == null || playersTeam.isSpawn())) {
            ServerLevel overworld = server.overworld();
            BlockPos worldSpawn = overworld.getSharedSpawnPos();
            player.teleportTo(overworld, (double)worldSpawn.getX(), (double)worldSpawn.getY(), (double)worldSpawn.getZ(), 0.0f, 0.0f);
            return;
        }
        ServerLevel level = WorldUtil.getConfiguredLevel(server);
        TemplatesConfig.Spawn spawn = WorldUtil.validPosition(level, team);
        player.teleportTo(level, (double)spawn.pos().getX() + 0.5, (double)spawn.pos().getY() + 0.2, (double)spawn.pos().getZ() + 0.5, (float)spawn.direction().getYRot(), 0.0f);
        if (player.getRespawnPosition() == null && team.hasPlayer((Player)player)) {
            player.setRespawnPosition(level.dimension(), spawn.pos(), (float)spawn.direction().getYRot(), true, false);
        }
        if (PermissionsConfig.Teleports.negateFallDamage) {
            player.fallDistance = 0.0f;
        }
    }

    public static boolean isSkyblock(Level level) {
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        if (PermissionsConfig.forceSkyblockCheck) {
            return true;
        }
        MinecraftServer server = ((ServerLevel)level).getServer();
        if (DimensionsConfig.Overworld.isCustom) {
            return server.overworld().getChunkSource().getGenerator() instanceof SkyblockNoiseBasedChunkGenerator;
        }
        if (DimensionsConfig.Nether.isCustom) {
            ServerLevel nether = server.getLevel(Level.NETHER);
            return nether != null && nether.getChunkSource().getGenerator() instanceof SkyblockNoiseBasedChunkGenerator;
        }
        if (DimensionsConfig.End.isCustom) {
            ServerLevel end = server.getLevel(Level.END);
            return end != null && end.getChunkSource().getGenerator() instanceof SkyblockEndChunkGenerator;
        }
        return false;
    }

    public static void checkSkyblock(CommandSourceStack source) throws CommandSyntaxException {
        if (!WorldUtil.isSkyblock((Level)source.getServer().overworld())) {
            throw new SimpleCommandExceptionType((Message)SkyComponents.NO_SKYBLOCK).create();
        }
    }

    public static ServerLevel getConfiguredLevel(MinecraftServer server) {
        ResourceLocation location = SpawnConfig.spawnDimension.location();
        ResourceKey worldKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)location);
        ServerLevel configLevel = server.getLevel(worldKey);
        if (configLevel == null) {
            SkyblockBuilder.getLogger().warn("Configured dimension for spawn does not exist: {}", (Object)location);
        }
        return configLevel != null ? configLevel : server.overworld();
    }

    private static TemplatesConfig.Spawn validPosition(ServerLevel level, Team team) {
        TemplatesConfig.Spawn spawn;
        ArrayList<TemplatesConfig.Spawn> spawns = new ArrayList<TemplatesConfig.Spawn>(team.getPossibleSpawns());
        Random random = new Random();
        while (!spawns.isEmpty()) {
            spawn = (TemplatesConfig.Spawn)spawns.get(random.nextInt(spawns.size()));
            if (WorldUtil.isValidSpawn((Level)level, spawn.pos())) {
                return spawn;
            }
            spawns.remove(spawn);
        }
        SkyblockBuilder.getLogger().info("No valid spawn position found, searching...");
        spawn = team.getPossibleSpawns().stream().findAny().orElse(new TemplatesConfig.Spawn(team.getIsland().getCenter(), SpawnDirection.SOUTH));
        return new TemplatesConfig.Spawn(PositionHelper.findPos(spawn.pos(), blockPos -> WorldUtil.isValidSpawn((Level)level, blockPos), SpawnConfig.radiusToFindValidSpawn), spawn.direction());
    }

    public static boolean isValidSpawn(Level level, BlockPos pos) {
        return WorldUtil.isValidSpawn(level, pos, level.getMinBuildHeight(), level.getMaxBuildHeight());
    }

    public static boolean isValidSpawn(Level level, BlockPos pos, int bottom, int top) {
        return pos.getY() >= bottom && pos.getY() <= top && (level.getBlockState(pos.below()).canOcclude() || level.getBlockState(pos.below()).is(ModBlockTags.ADDITIONAL_VALID_SPAWN)) && !level.getBlockState(pos).canOcclude() && !level.getBlockState(pos.above()).canOcclude();
    }

    public static int calcSpawnHeight(Level level, int x, int z) {
        int top = SpawnConfig.Height.range.top();
        int bottom = SpawnConfig.Height.range.bottom();
        int height = switch (SpawnConfig.Height.heightCalculationType) {
            default -> throw new MatchException(null, null);
            case SpawnSettings.Type.RANGE_TOP, SpawnSettings.Type.RANGE_BOTTOM -> {
                BlockPos.MutableBlockPos spawn = new BlockPos.MutableBlockPos(x, top, z);
                while (!WorldUtil.isValidSpawn(level, (BlockPos)spawn, bottom, top)) {
                    if (spawn.getY() <= level.getMinBuildHeight()) {
                        if (SpawnConfig.Height.heightCalculationType == SpawnSettings.Type.RANGE_TOP) {
                            spawn.setY(top);
                            break;
                        }
                        spawn.setY(bottom);
                        break;
                    }
                    spawn.move(Direction.DOWN, 1);
                }
                yield spawn.getY() + SpawnConfig.Height.offset;
            }
            case SpawnSettings.Type.SET -> bottom;
        };
        return Math.max(level.getMinBuildHeight() + 1, height);
    }

    public static CompoundTag blockPosToTag(BlockPos pos) {
        CompoundTag posTag = new CompoundTag();
        posTag.putInt("posX", pos.getX());
        posTag.putInt("posY", pos.getY());
        posTag.putInt("posZ", pos.getZ());
        return posTag;
    }

    public static BlockPos blockPosFromTag(CompoundTag posTag) {
        return new BlockPos(posTag.getInt("posX"), posTag.getInt("posY"), posTag.getInt("posZ"));
    }

    public static BlockPos blockPosFromJsonArray(JsonArray json) {
        if (json.size() != 3) {
            throw new IllegalStateException("Invalid BlockPos: " + String.valueOf(json));
        }
        return new BlockPos(json.get(0).getAsInt(), json.get(1).getAsInt(), json.get(2).getAsInt());
    }

    public static JsonArray blockPosToJsonArray(BlockPos pos) {
        JsonArray array = new JsonArray();
        array.add((Number)pos.getX());
        array.add((Number)pos.getY());
        array.add((Number)pos.getZ());
        return array;
    }

    public static Climate.ParameterPoint pointFor(ResourceKey<Biome> key) {
        long seed = key.location().toString().hashCode();
        seed ^= seed >>> 33;
        seed *= -49064778989728563L;
        seed ^= seed >>> 33;
        seed *= -4265267296055464877L;
        seed ^= seed >>> 33;
        RandomSource r = RandomSource.create((long)seed);
        float t = r.nextFloat() * 4.0f - 2.0f;
        float h = r.nextFloat() * 4.0f - 2.0f;
        float c = r.nextFloat() * 4.0f - 2.0f;
        float e = r.nextFloat() * 4.0f - 2.0f;
        float d = r.nextFloat() * 4.0f - 2.0f;
        float w = r.nextFloat() * 4.0f - 2.0f;
        float o = r.nextFloat();
        return Climate.parameters((float)t, (float)h, (float)c, (float)e, (float)d, (float)w, (float)o);
    }

    public static enum SpawnDirection {
        NORTH(180),
        EAST(270),
        SOUTH(0),
        WEST(90);

        private final int yRot;

        private SpawnDirection(int yaw) {
            this.yRot = yaw;
        }

        public static SpawnDirection fromDirection(Direction direction) {
            return switch (direction) {
                case Direction.NORTH -> NORTH;
                case Direction.EAST -> EAST;
                case Direction.WEST -> WEST;
                default -> SOUTH;
            };
        }

        public int getYRot() {
            return this.yRot;
        }
    }
}

