/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.network;

import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.item.ItemStructureSaver;
import de.melanx.skyblockbuilder.item.StructureSaverSettings;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.util.SkyPaths;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import org.moddingx.libx.network.PacketHandler;

public class SaveStructureHandler
extends PacketHandler<Message> {
    public static final CustomPacketPayload.Type<Message> TYPE = new CustomPacketPayload.Type(SkyblockBuilder.getInstance().resource("save_structure"));

    protected SaveStructureHandler() {
        super(TYPE, PacketFlow.SERVERBOUND, Message.CODEC, HandlerThread.MAIN);
    }

    public void handle(Message msg, IPayloadContext ctx) {
        Player player = ctx.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ServerLevel level = (ServerLevel)player2.level();
        String name = ItemStructureSaver.saveSchematic(player2, (Level)level, msg.stack, msg.settings);
        if (name == null) {
            player2.displayClientMessage((Component)Component.literal((String)"Failed to save, look at latest.log for more information").withStyle(ChatFormatting.RED), false);
            return;
        }
        if (!msg.settings.keepPositions()) {
            ItemStack stack = ItemStructureSaver.removeComponents(msg.stack);
            player2.setItemInHand(InteractionHand.MAIN_HAND, stack);
        }
        Path fullPath = msg.settings.saveToConfig() ? SkyPaths.MOD_CONFIG.resolve(name) : SkyPaths.MOD_EXPORTS.resolve(name);
        Path savedPath = FMLPaths.GAMEDIR.get().relativize(fullPath);
        MutableComponent component = SkyComponents.SCHEMATIC_SAVED.apply(savedPath.toString().replace('\\', '/'));
        SkyblockBuilder.getLogger().info("Saved structure (and spawn points) to: {}", (Object)fullPath);
        player2.displayClientMessage((Component)component, true);
    }

    public record Message(ItemStack stack, StructureSaverSettings settings) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Message> CODEC = StreamCodec.of((buffer, msg) -> {
            ItemStack.STREAM_CODEC.encode(buffer, (Object)msg.stack);
            StructureSaverSettings.STREAM_CODEC.encode(buffer, (Object)msg.settings);
        }, buffer -> new Message((ItemStack)ItemStack.STREAM_CODEC.decode(buffer), (StructureSaverSettings)StructureSaverSettings.STREAM_CODEC.decode(buffer)));

        @Nonnull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

