/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.teleport;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.commands.Suggestions;
import de.melanx.skyblockbuilder.config.common.PermissionsConfig;
import de.melanx.skyblockbuilder.data.SkyMeta;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.CommandUtil;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.util.WorldUtil;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class VisitCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"visit").then(Commands.argument((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.VISIT_TEAMS).executes(context -> VisitCommand.visit((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"team"))));
    }

    private static int visit(CommandSourceStack source, String name) throws CommandSyntaxException {
        CommandUtil.ValidationResult validationResult = CommandUtil.validateTeamExistence(source, name);
        if (validationResult == null) {
            return 0;
        }
        ServerPlayer player = validationResult.player();
        Level level = player.level();
        SkyblockSavedData data = validationResult.data();
        Team team = validationResult.team();
        if (!PermissionManager.INSTANCE.mayBypassLimitation((Player)player) && !data.getOrCreateMetaInfo((Player)player).canTeleport(SkyMeta.TeleportType.VISIT, level.getGameTime())) {
            source.sendFailure((Component)SkyComponents.ERROR_COOLDOWN.apply(RandomUtility.formattedCooldown((long)PermissionsConfig.Teleports.Cooldowns.visitCooldown - (level.getGameTime() - data.getOrCreateMetaInfo((Player)player).getLastTeleport(SkyMeta.TeleportType.VISIT)))));
            return 0;
        }
        if (CommandUtil.mayNotTeleport(source, data, player)) {
            return 0;
        }
        switch (SkyblockHooks.onTeleportToVisit(player, team)) {
            case DENY: {
                source.sendFailure((Component)SkyComponents.DENIED_VISIT_TEAM);
                return 0;
            }
            case DEFAULT: {
                if (team.hasPlayer((Player)player)) {
                    source.sendFailure((Component)SkyComponents.ERROR_VISIT_OWN_TEAM);
                    return 0;
                }
                if (PermissionManager.INSTANCE.mayExecuteOpCommand((Player)player)) break;
                if (!PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.TELEPORT_TO_VISITING_ISLAND)) {
                    source.sendFailure((Component)SkyComponents.DISABLED_TEAM_VISIT);
                    return 0;
                }
                if (team.allowsVisits()) break;
                source.sendFailure((Component)SkyComponents.DISABLED_VISIT_TEAM);
                return 0;
            }
        }
        WorldUtil.teleportToIsland(player, team);
        data.getOrCreateMetaInfo((Player)player).setLastTeleport(SkyMeta.TeleportType.VISIT, level.getGameTime());
        source.sendSuccess(() -> (Component)SkyComponents.SUCCESS_VISIT_TEAM.apply(name), true);
        return 1;
    }
}

