/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.team;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.events.SkyblockManageTeamEvent;
import de.melanx.skyblockbuilder.util.CommandUtil;
import de.melanx.skyblockbuilder.util.SkyComponents;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.tuple.Pair;

public class ToggleTeamSettingsCommand {
    static ArgumentBuilder<CommandSourceStack, ?> registerAllowVisit() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"allowVisit").executes(context -> ToggleTeamSettingsCommand.toggleAllowVisit((CommandSourceStack)context.getSource()))).then(Commands.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(context -> ToggleTeamSettingsCommand.toggleAllowVisit((CommandSourceStack)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"enabled"))));
    }

    static ArgumentBuilder<CommandSourceStack, ?> registerAllowRequest() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"allowRequests").executes(context -> ToggleTeamSettingsCommand.toggleAllowRequest((CommandSourceStack)context.getSource()))).then(Commands.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(context -> ToggleTeamSettingsCommand.toggleAllowRequest((CommandSourceStack)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"enabled"))));
    }

    private static int toggleAllowVisit(CommandSourceStack source) throws CommandSyntaxException {
        CommandUtil.ValidationResult validationResult = CommandUtil.validatePlayerTeam(source);
        if (validationResult == null) {
            return 0;
        }
        boolean enabled = validationResult.team().allowsVisits();
        return ToggleTeamSettingsCommand.toggleAllowVisit(source, enabled, validationResult);
    }

    private static int toggleAllowVisit(CommandSourceStack source, boolean enabled) throws CommandSyntaxException {
        return ToggleTeamSettingsCommand.toggleAllowVisit(source, enabled, CommandUtil.validatePlayerTeam(source));
    }

    private static int toggleAllowVisit(CommandSourceStack source, boolean enabled, CommandUtil.ValidationResult validationResult) {
        if (validationResult == null) {
            return 0;
        }
        Pair<SkyblockManageTeamEvent.Result, Boolean> result = SkyblockHooks.onToggleVisits(validationResult.player(), validationResult.team(), enabled);
        if (result.getLeft() == SkyblockManageTeamEvent.Result.DENY) {
            source.sendFailure((Component)SkyComponents.DENIED_TOGGLE_VISITS.apply((Component)(enabled ? SkyComponents.ARGUMENT_ENABLE : SkyComponents.ARGUMENT_DISABLE)));
            return 0;
        }
        validationResult.team().setAllowVisit((Boolean)result.getRight());
        source.sendSuccess(() -> SkyComponents.INFO_TOGGLE_VISIT.apply((Component)(enabled ? SkyComponents.ARGUMENT_ENABLED : SkyComponents.ARGUMENT_DISABLED)).withStyle(ChatFormatting.GOLD), false);
        return 1;
    }

    private static int toggleAllowRequest(CommandSourceStack source) throws CommandSyntaxException {
        CommandUtil.ValidationResult validationResult = CommandUtil.validatePlayerTeam(source);
        if (validationResult == null) {
            return 0;
        }
        boolean enabled = validationResult.team().allowsVisits();
        return ToggleTeamSettingsCommand.toggleAllowRequest(source, enabled, validationResult);
    }

    private static int toggleAllowRequest(CommandSourceStack source, boolean enabled) throws CommandSyntaxException {
        return ToggleTeamSettingsCommand.toggleAllowRequest(source, enabled, CommandUtil.validatePlayerTeam(source));
    }

    private static int toggleAllowRequest(CommandSourceStack source, boolean enabled, @Nullable CommandUtil.ValidationResult validationResult) {
        if (validationResult == null) {
            return 0;
        }
        Pair<SkyblockManageTeamEvent.Result, Boolean> result = SkyblockHooks.onToggleRequests(validationResult.player(), validationResult.team(), enabled);
        if (result.getLeft() == SkyblockManageTeamEvent.Result.DENY) {
            source.sendFailure((Component)SkyComponents.DENIED_TOGGLE_REQUEST.apply((Component)(enabled ? SkyComponents.ARGUMENT_ENABLE : SkyComponents.ARGUMENT_DISABLE)));
            return 0;
        }
        validationResult.team().setAllowJoinRequest((Boolean)result.getRight());
        source.sendSuccess(() -> SkyComponents.INFO_TOGGLE_REQUEST.apply((Component)(enabled ? SkyComponents.ARGUMENT_ENABLED : SkyComponents.ARGUMENT_DISABLED)).withStyle(ChatFormatting.GOLD), false);
        return 1;
    }
}

