/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.operator;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.commands.Suggestions;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.template.ConfiguredTemplate;
import de.melanx.skyblockbuilder.template.TemplateLoader;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.util.SkyPaths;
import de.melanx.skyblockbuilder.util.TemplateUtil;
import java.io.IOException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.moddingx.libx.command.CommandUtil;

public class GenerateCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"generate").requires(PermissionManager.INSTANCE::mayExecuteOpCommand)).then(Commands.literal((String)"template").then(((RequiredArgumentBuilder)Commands.argument((String)"template", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.TEMPLATES).executes(GenerateCommand::generateTemplate)).then(((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(GenerateCommand::generateTemplate)).then(((RequiredArgumentBuilder)Commands.argument((String)"border", (ArgumentType)BoolArgumentType.bool()).executes(GenerateCommand::generateTemplate)).then(Commands.argument((String)"spreads", (ArgumentType)BoolArgumentType.bool()).executes(GenerateCommand::generateTemplate))))))).then(Commands.literal((String)"spread").then(((RequiredArgumentBuilder)Commands.argument((String)"file", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.SPREADS).executes(GenerateCommand::generateSpread)).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(GenerateCommand::generateSpread))));
    }

    private static int generateTemplate(CommandContext<CommandSourceStack> context) {
        String template = StringArgumentType.getString(context, (String)"template");
        BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)context.getSource()).getPosition());
        boolean border = (Boolean)CommandUtil.getArgumentOrDefault(context, (String)"border", Boolean.class, (Object)false);
        boolean spreads = (Boolean)CommandUtil.getArgumentOrDefault(context, (String)"spreads", Boolean.class, (Object)false);
        try {
            pos = BlockPosArgument.getBlockPos(context, (String)"pos");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        ConfiguredTemplate configuredTemplate = TemplateLoader.getConfiguredTemplate(template);
        if (configuredTemplate == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)SkyComponents.COMMAND_GENERATED_FAIL);
            return 0;
        }
        if (spreads) {
            configuredTemplate.placeInWorld(level, pos, TemplateUtil.STRUCTURE_PLACE_SETTINGS, level.random, 2);
        } else {
            configuredTemplate.getTemplate().placeInWorld((ServerLevelAccessor)level, pos, pos, TemplateUtil.STRUCTURE_PLACE_SETTINGS, level.random, 2);
        }
        if (border) {
            SkyblockSavedData.surround(level, pos, configuredTemplate);
        }
        GenerateCommand.showLocationResult((CommandSourceStack)context.getSource(), template, pos);
        return 1;
    }

    private static int generateSpread(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CompoundTag nbt;
        String file = StringArgumentType.getString(context, (String)"file");
        BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)context.getSource()).getPosition());
        try {
            pos = BlockPosArgument.getBlockPos(context, (String)"pos");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            nbt = TemplateUtil.readTemplate(SkyPaths.SPREADS_DIR.resolve(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        StructureTemplate template = new StructureTemplate();
        template.load((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), nbt);
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        template.placeInWorld((ServerLevelAccessor)level, pos, pos, TemplateUtil.STRUCTURE_PLACE_SETTINGS, level.random, 2);
        GenerateCommand.showLocationResult((CommandSourceStack)context.getSource(), file, pos);
        return 1;
    }

    private static void showLocationResult(CommandSourceStack source, String structureName, BlockPos generatedAt) {
        Component coords = RandomUtility.getFormattedPos(generatedAt);
        source.sendSuccess(() -> (Component)SkyComponents.COMMAND_GENERATED_SUCCESS.apply(structureName, coords), true);
    }
}

