/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.helper;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.commands.Suggestions;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.util.CommandUtil;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.util.WorldUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.Level;

public class ListCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"list").executes(context -> ListCommand.listTeams((CommandSourceStack)context.getSource()))).then(Commands.argument((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.ALL_TEAMS).executes(context -> ListCommand.listPlayers((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"team"))));
    }

    private static int listTeams(CommandSourceStack source) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.getLevel();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        List<Team> teams = data.getTeams().stream().sorted(Comparator.comparing(Team::getName)).filter(team -> !team.getName().equalsIgnoreCase("spawn")).toList();
        MutableComponent info = SkyComponents.INFO_TEAMS.apply(teams.size(), teams.stream().filter(Team::isEmpty).count());
        info.withStyle(ChatFormatting.GOLD);
        source.sendSuccess(() -> info, false);
        for (Team team2 : teams) {
            if (team2.isSpawn()) continue;
            MutableComponent list = Component.literal((String)("- " + team2.getName()));
            if (team2.isEmpty()) {
                list.append(" (");
                list.append((Component)SkyComponents.ARGUMENT_EMPTY);
                list.append(")");
                list.withStyle(ChatFormatting.RED);
            } else {
                list.withStyle(ChatFormatting.GREEN);
            }
            source.sendSuccess(() -> list, false);
        }
        return 1;
    }

    private static int listPlayers(CommandSourceStack source, String teamName) throws CommandSyntaxException {
        CommandUtil.ValidationResult validationResult = CommandUtil.validateTeamExistence(source, teamName);
        if (validationResult == null) {
            return 0;
        }
        Team team = validationResult.team();
        GameProfileCache profileCache = source.getServer().getProfileCache();
        assert (profileCache != null);
        source.sendSuccess(() -> (Component)SkyComponents.INFO_TEAM_DETAILED.apply(team.getName(), team.getPlayers().size()), false);
        team.getPlayers().forEach(id -> {
            String name;
            Optional profile = profileCache.get(id);
            if (profile.isPresent() && !StringUtil.isNullOrEmpty((String)(name = ((GameProfile)profile.get()).getName()))) {
                source.sendSuccess(() -> Component.literal((String)("- " + name)), false);
            }
        });
        return 1;
    }
}

