/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.api.SkyblockBuilderAPI;
import de.melanx.skyblockbuilder.client.GameProfileCache;
import de.melanx.skyblockbuilder.commands.CreateCommand;
import de.melanx.skyblockbuilder.commands.LeaveCommand;
import de.melanx.skyblockbuilder.commands.helper.ConvertCommand;
import de.melanx.skyblockbuilder.commands.helper.InventoryCommand;
import de.melanx.skyblockbuilder.commands.helper.ListCommand;
import de.melanx.skyblockbuilder.commands.helper.LocateCommand;
import de.melanx.skyblockbuilder.commands.helper.SpawnsCommand;
import de.melanx.skyblockbuilder.commands.invitation.AcceptCommand;
import de.melanx.skyblockbuilder.commands.invitation.DeclineCommand;
import de.melanx.skyblockbuilder.commands.invitation.InviteCommand;
import de.melanx.skyblockbuilder.commands.invitation.JoinCommand;
import de.melanx.skyblockbuilder.commands.operator.GenerateCommand;
import de.melanx.skyblockbuilder.commands.operator.ManageCommand;
import de.melanx.skyblockbuilder.commands.team.TeamCommandBase;
import de.melanx.skyblockbuilder.commands.teleport.HomeCommand;
import de.melanx.skyblockbuilder.commands.teleport.SpawnCommand;
import de.melanx.skyblockbuilder.commands.teleport.VisitCommand;
import de.melanx.skyblockbuilder.compat.CadmusCompat;
import de.melanx.skyblockbuilder.config.common.CustomizationConfig;
import de.melanx.skyblockbuilder.config.common.DimensionsConfig;
import de.melanx.skyblockbuilder.config.common.InventoryConfig;
import de.melanx.skyblockbuilder.config.common.PermissionsConfig;
import de.melanx.skyblockbuilder.config.common.SpawnConfig;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.config.common.WorldConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.data.TemplateData;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.template.TemplateLoader;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyPaths;
import de.melanx.skyblockbuilder.util.WorldUtil;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import org.moddingx.libx.event.ConfigLoadedEvent;

@EventBusSubscriber(modid="skyblockbuilder")
public class EventListener {
    private static final String SPAWNED_TAG = "alreadySpawned";

    @SubscribeEvent
    public static void resourcesReload(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            return;
        }
        SkyPaths.generateDefaultFiles(event.getPlayerList().getServer());
        TemplateLoader.updateTemplates();
        SkyblockBuilder.getNetwork().updateTemplateNames(TemplateLoader.getTemplateNames());
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register(LocateCommand.register());
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sky").requires(source -> SkyblockBuilderAPI.teamManagementEnabled())).then(AcceptCommand.register())).then(CreateCommand.register())).then(DeclineCommand.register())).then(HomeCommand.register())).then(InviteCommand.register())).then(JoinCommand.register())).then(LeaveCommand.register())).then(ListCommand.register())).then(SpawnCommand.register())).then(SpawnsCommand.register())).then(TeamCommandBase.register())).then(VisitCommand.register()));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"skydev").requires(PermissionManager.INSTANCE::mayExecuteOpCommand)).then(ConvertCommand.register())).then(GenerateCommand.register())).then(InventoryCommand.register())).then(ManageCommand.register()));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"skyblock").requires(source -> SkyblockBuilderAPI.teamManagementEnabled())).then(AcceptCommand.register())).then(ConvertCommand.register())).then(CreateCommand.register())).then(DeclineCommand.register())).then(GenerateCommand.register())).then(HomeCommand.register())).then(InventoryCommand.register())).then(InviteCommand.register())).then(JoinCommand.register())).then(LeaveCommand.register())).then(ListCommand.register())).then(ManageCommand.register())).then(SpawnCommand.register())).then(SpawnsCommand.register())).then(TeamCommandBase.register())).then(VisitCommand.register()));
        if (ModList.get().isLoaded("cadmus")) {
            event.getDispatcher().register(CadmusCompat.spawnProtectionCommand());
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LightningBolt) {
            LightningBolt lightning = (LightningBolt)entity;
            if (WorldUtil.isSkyblock(event.getLevel())) {
                ServerLevel level = (ServerLevel)event.getLevel();
                BlockPos pos = new BlockPos((int)lightning.position().x, level.getSeaLevel(), (int)lightning.position().z);
                Optional rodPos = level.findLightningRod(pos);
                rodPos.ifPresent(blockPos -> lightning.moveTo(Vec3.atBottomCenterOf((Vec3i)blockPos)));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        SkyblockBuilder.getNetwork().updateData(event.getEntity(), null);
        Level level = event.getEntity().level();
        SkyblockBuilder.getNetwork().updateProfiles(level);
        SkyblockBuilder.getNetwork().updateTemplateNames(event.getEntity(), TemplateLoader.getTemplateNames());
        if (level instanceof ServerLevel && WorldUtil.isSkyblock(level) && SkyblockBuilderAPI.isSpawnTeleportEnabled()) {
            SkyblockSavedData data = SkyblockSavedData.get(level);
            ServerPlayer player = (ServerPlayer)event.getEntity();
            Team spawn = data.getSpawn();
            GameProfileCache.addProfiles(Set.of(player.getGameProfile()));
            if (player.getPersistentData().getBoolean(SPAWNED_TAG)) {
                if (!data.hasPlayerTeam((Player)player) && !spawn.hasPlayer((Player)player)) {
                    if (InventoryConfig.dropItems) {
                        RandomUtility.dropInventories((Player)player);
                    }
                    WorldUtil.teleportToIsland(player, spawn);
                    data.addPlayerToTeam(SkyblockSavedData.SPAWN_ID, (Player)player);
                    SkyblockBuilder.getLogger().info("Put {} back into spawn team.", (Object)player.getDisplayName());
                }
                return;
            }
            player.getPersistentData().putBoolean(SPAWNED_TAG, true);
            data.getOrCreateMetaInfo((Player)player);
            if (InventoryConfig.clearInitialInventory) {
                player.getInventory().clearContent();
            }
            SkyblockBuilder.getLogger().info("First time {} joined. Putting into spawn team.", (Object)player.getDisplayName().getString());
            data.addPlayerToTeam(spawn, (Player)player);
            try {
                TemplatesConfig.Spawn spawnPos = !spawn.getDefaultPossibleSpawns().isEmpty() ? (TemplatesConfig.Spawn)spawn.getDefaultPossibleSpawns().stream().findFirst().get() : (TemplatesConfig.Spawn)spawn.getPossibleSpawns().stream().findFirst().get();
                ((ServerLevel)level).setDefaultSpawnPos(spawnPos.pos(), (float)spawnPos.direction().getYRot());
            }
            catch (NoSuchElementException e) {
                throw new IllegalStateException("No possible spawn point set for spawn", e);
            }
            WorldUtil.teleportToIsland(player, spawn);
        }
    }

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        Player newPlayer = event.getEntity();
        CompoundTag newData = newPlayer.getPersistentData();
        Player oldPlayer = event.getOriginal();
        CompoundTag oldData = oldPlayer.getPersistentData();
        newData.putBoolean(SPAWNED_TAG, oldData.getBoolean(SPAWNED_TAG));
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.getEntity().level().isClientSide) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            BlockPos pos = player.getRespawnPosition();
            ServerLevel level = (ServerLevel)player.level();
            if (!WorldUtil.isSkyblock((Level)level)) {
                return;
            }
            if (pos == null || !level.getBlockState(pos).is(BlockTags.BEDS) && !level.getBlockState(pos).is(Blocks.RESPAWN_ANCHOR)) {
                SkyblockSavedData data = SkyblockSavedData.get((Level)level);
                Team team = data.getTeamFromPlayer((Player)player);
                WorldUtil.teleportToIsland(player, team == null ? data.getSpawn() : team);
            }
        }
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        SkyPaths.generateDefaultFiles(server);
        if (WorldUtil.isSkyblock((Level)server.overworld())) {
            SkyblockBuilder.getLogger().info("Successfully loaded Skyblock!");
            TemplateLoader.updateTemplates();
            SkyblockBuilder.getNetwork().updateTemplateNames(TemplateLoader.getTemplateNames());
            TemplateData.get(server.overworld());
            Set<GameProfile> profiles = RandomUtility.getGameProfiles(server.overworld());
            GameProfileCache.addProfiles(profiles);
            if (SkyblockBuilderAPI.isSpawnTeleportEnabled()) {
                SkyblockSavedData.get((Level)server.overworld()).getSpawn();
            }
        }
    }

    @SubscribeEvent
    public static void onTabListName(PlayerEvent.TabListNameFormat event) {
        if (!CustomizationConfig.showTeamInTabList) {
            return;
        }
        Player player = event.getEntity();
        Team team = SkyblockSavedData.get(player.level()).getTeamFromPlayer(player);
        if (team != null) {
            MutableComponent name = (MutableComponent)player.getDisplayName();
            Style style = name.getStyle();
            if (style.getColor() == null) {
                style.withColor(ChatFormatting.WHITE);
            }
            MutableComponent teamName = Component.literal((String)team.getName()).withStyle(ChatFormatting.AQUA);
            event.setDisplayName((Component)Component.empty().append((Component)Component.literal((String)"[").withStyle(style)).append((Component)teamName.withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)"] ").withStyle(style)).append((Component)name.withStyle(style)));
        } else {
            event.setDisplayName(null);
        }
    }

    @SubscribeEvent
    public static void onConfigChange(ConfigLoadedEvent event) {
        if (event.getConfigClass() == TemplatesConfig.class && event.getReason() != ConfigLoadedEvent.LoadReason.SHADOW) {
            TemplateLoader.updateTemplates();
        }
        if (event.getConfigClass() == PermissionsConfig.class && PermissionsConfig.forceSkyblockCheck) {
            SkyblockBuilder.getLogger().warn("'forceSkyblockCheck' is enabled");
        }
        if (event.getConfigClass() == WorldConfig.class || event.getConfigClass() == DimensionsConfig.class || event.getConfigClass() == SpawnConfig.class) {
            int overworldCenterBiomesRadius = DimensionsConfig.Overworld.centeredBiomes.stream().mapToInt(DimensionsConfig.UnregisteredCenterBiome::radius).sum();
            int netherCenterBiomesRadius = DimensionsConfig.Nether.centeredBiomes.stream().mapToInt(DimensionsConfig.UnregisteredCenterBiome::radius).sum();
            if (SpawnConfig.spawnDimension == Level.OVERWORLD && overworldCenterBiomesRadius > WorldConfig.islandDistance) {
                SkyblockBuilder.getLogger().warn("The overworld center biomes radius is higher than the island distance. This will result in unwanted behaviour.");
            }
            if (SpawnConfig.spawnDimension == Level.NETHER && netherCenterBiomesRadius > WorldConfig.islandDistance) {
                SkyblockBuilder.getLogger().warn("The nether center biomes radius is higher than the island distance. This will result in unwanted behaviour.");
            }
        }
    }
}

