/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.template;

import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.config.values.providers.SpawnsProvider;
import de.melanx.skyblockbuilder.config.values.providers.SpreadsProvider;
import de.melanx.skyblockbuilder.config.values.providers.SurroundingBlocksProvider;
import de.melanx.skyblockbuilder.template.ConfiguredTemplate;
import de.melanx.skyblockbuilder.template.NetherPortalTemplate;
import de.melanx.skyblockbuilder.template.TemplateInfo;
import de.melanx.skyblockbuilder.util.SkyPaths;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class TemplateLoader {
    private static final List<String> TEMPLATE_NAMES = new ArrayList<String>();
    private static final Map<String, ConfiguredTemplate> TEMPLATE_MAP = new HashMap<String, ConfiguredTemplate>();
    private static ConfiguredTemplate TEMPLATE;
    private static Optional<Integer> PALETTE_INDEX;
    private static NetherPortalTemplate NETHER_PORTAL;

    /*
     * Loose catch block
     */
    public static void updateTemplates() {
        block17: {
            try {
                TEMPLATE_NAMES.clear();
                TEMPLATE_MAP.clear();
                NETHER_PORTAL = null;
                SkyPaths.copyTemplateFile();
                HashSet<String> takenNames2333333332 = new HashSet<String>();
                for (TemplateInfo info : TemplatesConfig.templateList) {
                    block16: {
                        String name;
                        String string;
                        Record record;
                        Object object;
                        block15: {
                            block14: {
                                object = info.spawns();
                                if (object instanceof SpawnsProvider.Reference) {
                                    record = (SpawnsProvider.Reference)object;
                                    name = string = ((SpawnsProvider.Reference)record).name();
                                    if (TemplatesConfig.spawnPointReferences.containsKey(name)) break block14;
                                    throw new IllegalArgumentException("Spawns configuration \"" + String.valueOf(info.spawns()) + "\" is not defined: " + info.name());
                                }
                            }
                            if (info.spawns().templateSpawns().allEmpty()) {
                                throw new IllegalArgumentException("Spawns configuration \"" + String.valueOf(info.spawns()) + "\" is empty: " + info.name());
                            }
                            object = info.surroundingBlocks();
                            if (object instanceof SurroundingBlocksProvider.Reference) {
                                record = (SurroundingBlocksProvider.Reference)object;
                                name = string = ((SurroundingBlocksProvider.Reference)record).name();
                                if (TemplatesConfig.surroundingBlockReferences.containsKey(name)) break block15;
                                throw new IllegalArgumentException("Surrounding blocks configuration \"" + String.valueOf(info.surroundingBlocks()) + "\" is not defined: " + info.name());
                            }
                        }
                        if ((object = info.spreads()) instanceof SpreadsProvider.Reference) {
                            record = (SpreadsProvider.Reference)object;
                            name = string = ((SpreadsProvider.Reference)record).name();
                            if (TemplatesConfig.spreadReferences.containsKey(name)) break block16;
                            throw new IllegalArgumentException("Spreads configuration \"" + String.valueOf(info.spreads()) + "\" is not defined: " + info.name());
                        }
                    }
                    if (!SkyPaths.ISLANDS_DIR.resolve(info.file()).toFile().exists()) {
                        throw new IllegalArgumentException("Template file \"" + info.file() + "\" does not exist: " + info.name());
                    }
                    if (takenNames2333333332.contains(info.name().toLowerCase(Locale.ROOT))) {
                        throw new IllegalArgumentException("Template name \"" + info.name() + "\" is defined too many times.");
                    }
                    takenNames2333333332.add(info.name().toLowerCase(Locale.ROOT));
                    ConfiguredTemplate template = new ConfiguredTemplate(info);
                    TEMPLATE_NAMES.add(info.name());
                    TEMPLATE_MAP.put(info.name().toLowerCase(Locale.ROOT), template);
                    SkyblockBuilder.getLogger().info("Loaded template \"{}\" from \"{}\".", (Object)info.name(), (Object)info.file());
                }
                if (TEMPLATE_MAP.isEmpty()) {
                    throw new IllegalStateException("You need at least one configured template.");
                }
                TEMPLATE = TEMPLATE == null ? TEMPLATE_MAP.get(TEMPLATE_NAMES.getFirst().toLowerCase(Locale.ROOT)) : TemplateLoader.getConfiguredTemplate(TEMPLATE.getName(), false);
                Optional<File> netherPortalFile = Arrays.stream(SkyPaths.PORTALS_DIR.toFile().listFiles()).filter(SkyPaths.NBT_OR_SNBT).filter(file -> file.getName().startsWith("to_nether")).findFirst();
                netherPortalFile.ifPresent(file -> {
                    NETHER_PORTAL = new NetherPortalTemplate((File)file);
                });
                break block17;
                catch (Throwable takenNames2333333332) {
                    throw new MatchException(takenNames2333333332.toString(), takenNames2333333332);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot load templates.", e);
            }
        }
    }

    public static void updateTemplateNames(List<String> names) {
        TEMPLATE_NAMES.clear();
        TEMPLATE_NAMES.addAll(names);
    }

    public static List<String> getTemplateNames() {
        return TEMPLATE_NAMES;
    }

    public static List<ConfiguredTemplate> getConfiguredTemplates() {
        ArrayList<ConfiguredTemplate> templates = new ArrayList<ConfiguredTemplate>(TEMPLATE_MAP.values());
        templates.sort(Comparator.comparing(ConfiguredTemplate::getName));
        return templates;
    }

    public static void setTemplate(ConfiguredTemplate template) {
        TemplateLoader.setTemplate(template, Optional.empty());
    }

    public static void setTemplate(ConfiguredTemplate template, Optional<Integer> paletteIndex) {
        TEMPLATE = template;
        PALETTE_INDEX = paletteIndex;
    }

    public static StructureTemplate getTemplate() {
        if (TEMPLATE == null) {
            throw new IllegalStateException("Tried to access template before set.");
        }
        return TEMPLATE.getTemplate();
    }

    @Nullable
    public static ConfiguredTemplate getConfiguredTemplate(String name) {
        return TemplateLoader.getConfiguredTemplate(name, true);
    }

    @Nullable
    public static ConfiguredTemplate getConfiguredTemplate(String name, boolean randomPalette) {
        ConfiguredTemplate configuredTemplate = TEMPLATE_MAP.get(name.toLowerCase(Locale.ROOT));
        if (!randomPalette && PALETTE_INDEX.isPresent()) {
            configuredTemplate = configuredTemplate.onlyWithPalette(PALETTE_INDEX.get());
        }
        return configuredTemplate;
    }

    public static ConfiguredTemplate getConfiguredTemplate() {
        return TEMPLATE;
    }

    public static NetherPortalTemplate getNetherPortalTemplate() {
        return NETHER_PORTAL;
    }

    public static Set<TemplatesConfig.Spawn> getCurrentSpawns() {
        return TEMPLATE.getDefaultSpawns();
    }

    static {
        PALETTE_INDEX = Optional.empty();
    }
}

