/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.network;

import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.client.ClientUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nonnull;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import org.moddingx.libx.network.PacketHandler;

public class ExportErrorHandler
extends PacketHandler<Message> {
    public static final CustomPacketPayload.Type<Message> TYPE = new CustomPacketPayload.Type(SkyblockBuilder.getInstance().resource("export_error"));

    protected ExportErrorHandler() {
        super(TYPE, PacketFlow.CLIENTBOUND, Message.CODEC, HandlerThread.MAIN);
    }

    public void handle(Message msg, IPayloadContext ctx) {
        Path configPath = Paths.get(msg.configPath, new String[0]);
        ClientUtil.openErrorScreen(configPath, msg.reason);
    }

    public record Message(String configPath, String reason) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Message> CODEC = StreamCodec.of((buffer, msg) -> {
            buffer.writeUtf(msg.configPath);
            buffer.writeUtf(msg.reason);
        }, buffer -> new Message(buffer.readUtf(), buffer.readUtf()));

        @Nonnull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

