/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.compat;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.config.common.CadmusConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.SkyComponents;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class CadmusCompat {
    public static final String MODID = "cadmus";

    public static LiteralArgumentBuilder<CommandSourceStack> spawnProtectionCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)MODID).requires(PermissionManager.INSTANCE::mayExecuteOpCommand)).then(Commands.literal((String)SkyblockBuilder.getInstance().modid).then(Commands.literal((String)"protectSpawn").executes(source -> {
            ServerLevel level = ((CommandSourceStack)source.getSource()).getLevel();
            SkyblockSavedData data = SkyblockSavedData.get((Level)level);
            CadmusCompat.protectSpawn(level, data.getSpawn(), true);
            ((CommandSourceStack)source.getSource()).sendSuccess(() -> SkyComponents.CADMUS_CLAIM_SPAWN, true);
            return 1;
        })));
    }

    public static void protectSpawn(ServerLevel level, Team spawnTeam) {
        CadmusCompat.protectSpawn(level, spawnTeam, false);
    }

    public static void protectSpawn(ServerLevel level, Team spawnTeam, boolean forced) {
        if (!CadmusConfig.protectSpawnChunks && !forced) {
            return;
        }
    }
}

