/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.NameGenerator;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.util.WorldUtil;
import java.util.Random;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class CreateCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"create").requires(source -> PermissionManager.INSTANCE.hasPermission((CommandSourceStack)source, PermissionManager.Permission.TEAM_CREATE))).executes(context -> CreateCommand.create((CommandSourceStack)context.getSource(), null))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> CreateCommand.create((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"))));
    }

    private static int create(CommandSourceStack source, String name) throws CommandSyntaxException {
        ServerPlayer player;
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.getLevel();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        name = CreateCommand.generateName(name, data);
        if (SkyblockHooks.onCreateTeam(name)) {
            source.sendFailure((Component)SkyComponents.DENIED_CREATE_TEAM);
            return 0;
        }
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer && data.hasPlayerTeam((Player)(player = (ServerPlayer)entity))) {
            source.sendFailure((Component)SkyComponents.ERROR_USER_HAS_TEAM);
            return 0;
        }
        if (name.length() > 64) {
            source.sendFailure((Component)SkyComponents.ERROR_NAME_LENGTH.apply(name));
            return 0;
        }
        Team team = data.createTeam(name);
        String finalName = name;
        if (team == null) {
            source.sendFailure((Component)SkyComponents.ERROR_TEAM_ALREADY_EXIST.apply(finalName));
            return 0;
        }
        Entity entity2 = source.getEntity();
        if (entity2 instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)entity2;
            data.addPlayerToTeam(team, (Player)player2);
            WorldUtil.teleportToIsland(player2, team);
            source.sendSuccess(() -> (Component)SkyComponents.SUCCESS_CREATE_TEAM.apply(finalName), true);
            return 1;
        }
        return 0;
    }

    private static String generateName(String name, SkyblockSavedData data) {
        if (name == null) {
            Random rand = new Random();
            while (data.teamExists(name = NameGenerator.randomName(rand))) {
            }
        }
        return name;
    }
}

