/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.client;

import de.melanx.skyblockbuilder.SkyblockBuilder;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.EventLoop;
import java.net.SocketAddress;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerLinks;
import net.minecraft.world.Difficulty;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.neoforged.neoforge.network.connection.ConnectionType;

public class FakeLevel
extends ClientLevel {
    private static final ResourceKey<Level> FAKE_LEVEL_KEY = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)SkyblockBuilder.getInstance().resource("fake"));
    private static FakeLevel instance;

    public FakeLevel(RegistryAccess registryAccess) {
        super(FakeLevel.fakeClientPacketListener(registryAccess), new ClientLevel.ClientLevelData(Difficulty.EASY, false, true), FAKE_LEVEL_KEY, (Holder)registryAccess.registryOrThrow(Registries.DIMENSION_TYPE).getHolderOrThrow(BuiltinDimensionTypes.OVERWORLD), 0, 0, () -> ((Minecraft)Minecraft.getInstance()).getProfiler(), new LevelRenderer(Minecraft.getInstance(), Minecraft.getInstance().getEntityRenderDispatcher(), Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().renderBuffers()), false, 0L);
    }

    public static FakeLevel getInstance(RegistryAccess registryAccess) {
        if (instance == null) {
            instance = new FakeLevel(registryAccess);
        }
        return instance;
    }

    private static CommonListenerCookie getFakeListenerCookie(RegistryAccess registryAccess) {
        return new CommonListenerCookie(Minecraft.getInstance().getGameProfile(), Minecraft.getInstance().getTelemetryManager().createWorldSessionManager(false, null, null), registryAccess.freeze(), FeatureFlags.DEFAULT_FLAGS, null, null, null, Map.of(), null, false, Map.of(), ServerLinks.EMPTY, ConnectionType.OTHER);
    }

    private static ClientPacketListener fakeClientPacketListener(RegistryAccess registryAccess) {
        Connection connection = new Connection(PacketFlow.CLIENTBOUND);
        connection.channel = new FakeChannel();
        CommonListenerCookie fakeListenerCookie = FakeLevel.getFakeListenerCookie(registryAccess);
        return new ClientPacketListener(Minecraft.getInstance(), connection, fakeListenerCookie);
    }

    private static class FakeChannel
    extends AbstractChannel {
        private static final ChannelMetadata METADATA = new ChannelMetadata(false);
        private final ChannelConfig config = new DefaultChannelConfig((Channel)this);

        protected FakeChannel() {
            super(null);
        }

        protected AbstractChannel.AbstractUnsafe newUnsafe() {
            return new FakeChannelUnsafe(this);
        }

        protected boolean isCompatible(EventLoop loop) {
            return false;
        }

        protected SocketAddress localAddress0() {
            return null;
        }

        protected SocketAddress remoteAddress0() {
            return null;
        }

        protected void doBind(SocketAddress localAddress) {
            throw new UnsupportedOperationException();
        }

        protected void doDisconnect() {
            throw new UnsupportedOperationException();
        }

        protected void doClose() {
            throw new UnsupportedOperationException();
        }

        protected void doBeginRead() {
            throw new UnsupportedOperationException();
        }

        protected void doWrite(ChannelOutboundBuffer in) {
            throw new UnsupportedOperationException();
        }

        public ChannelConfig config() {
            return this.config;
        }

        public boolean isOpen() {
            return false;
        }

        public boolean isActive() {
            return false;
        }

        public ChannelMetadata metadata() {
            return METADATA;
        }

        private final class FakeChannelUnsafe
        extends AbstractChannel.AbstractUnsafe {
            private FakeChannelUnsafe(FakeChannel fakeChannel) {
                super((AbstractChannel)fakeChannel);
            }

            public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
                promise.setFailure((Throwable)new UnsupportedOperationException());
            }
        }
    }
}

