/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.spreads;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.melanx.skyblockbuilder.spreads.SingleSpreadEntry;
import de.melanx.skyblockbuilder.spreads.SingleWeightedSpreadEntry;
import de.melanx.skyblockbuilder.spreads.WeightedSpread;
import de.melanx.skyblockbuilder.util.SkyCodecs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import org.apache.commons.lang3.tuple.Pair;

public class GroupWeightedSpreadEntry
implements WeightedSpread {
    public static final int DEFAULT_WEIGHT = 1;
    public static final Codec<GroupWeightedSpreadEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SingleWeightedSpreadEntry.CODEC.listOf().fieldOf("entries").forGetter(GroupWeightedSpreadEntry::entries), (App)Codec.INT.optionalFieldOf("weight", (Object)1).forGetter(GroupWeightedSpreadEntry::weight), (App)Codec.INT.optionalFieldOf("amount").forGetter(GroupWeightedSpreadEntry::amount), (App)AutoSpread.CODEC.optionalFieldOf("auto_spread").forGetter(GroupWeightedSpreadEntry::autoSpread)).apply((Applicative)instance, GroupWeightedSpreadEntry::new));
    public static GroupWeightedSpreadEntry EMPTY = new GroupWeightedSpreadEntry(List.of(), 1, Optional.empty(), Optional.empty());
    private final List<SingleWeightedSpreadEntry> entries;
    private final int weight;
    private final int amount;
    private final Optional<AutoSpread> autoSpread;

    public GroupWeightedSpreadEntry(List<SingleWeightedSpreadEntry> entries, int weight, Optional<Integer> amount, Optional<AutoSpread> autoSpread) {
        this.entries = entries;
        this.weight = weight;
        this.amount = amount.orElse(entries.size());
        this.autoSpread = autoSpread;
    }

    @Override
    public int weight() {
        return this.weight;
    }

    private List<SingleWeightedSpreadEntry> entries() {
        return List.copyOf(this.entries);
    }

    public Optional<AutoSpread> autoSpread() {
        return this.autoSpread;
    }

    public Optional<Integer> amount() {
        return this.amount == this.entries.size() ? Optional.empty() : Optional.of(this.amount);
    }

    public Set<SingleSpreadEntry> chooseEntries(RandomSource random) {
        if (this.amount > this.entries.size()) {
            throw new IllegalArgumentException("Requested amount exceeds the number of available entries.");
        }
        HashSet<SingleSpreadEntry> selectedEntries = new HashSet<SingleSpreadEntry>();
        List<Pair> weightedEntries = this.entries.stream().map(entry -> Pair.of((Object)entry, (Object)entry.weight())).toList();
        if (this.amount().isEmpty()) {
            selectedEntries.addAll(this.entries.stream().map(SingleWeightedSpreadEntry::spread).toList());
        } else {
            int totalWeight = weightedEntries.stream().mapToInt(Pair::getRight).sum();
            block0: while (selectedEntries.size() < this.amount) {
                int rand = random.nextInt(totalWeight);
                int cumulativeWeight = 0;
                for (Pair pair : weightedEntries) {
                    if (rand >= (cumulativeWeight += ((Integer)pair.getRight()).intValue()) || selectedEntries.contains(((SingleWeightedSpreadEntry)pair.getLeft()).spread())) continue;
                    selectedEntries.add(((SingleWeightedSpreadEntry)pair.getLeft()).spread());
                    continue block0;
                }
            }
        }
        this.autoSpread.ifPresent(spread -> spread.apply(selectedEntries));
        return selectedEntries;
    }

    public record AutoSpread(Shape shape, int radius) {
        public static final Codec<AutoSpread> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Shape.CODEC.optionalFieldOf("shape", (Object)Shape.CIRCLE).forGetter(AutoSpread::shape), (App)Codec.INT.fieldOf("radius").forGetter(AutoSpread::radius)).apply((Applicative)instance, AutoSpread::new));
        public static final AutoSpread DEFAULT = new AutoSpread(Shape.CIRCLE, 0);

        public void apply(Set<SingleSpreadEntry> entries) {
            List<Object> positions;
            int count = entries.size();
            if (count == 0) {
                return;
            }
            ArrayList<SingleSpreadEntry> entryList = new ArrayList<SingleSpreadEntry>(entries);
            entries.clear();
            if (Objects.requireNonNull(this.shape) == Shape.CIRCLE) {
                positions = new ArrayList();
                double angleStep = Math.PI * 2 / (double)count;
                for (int i = 0; i < count; ++i) {
                    double angle = (double)i * angleStep;
                    int x = (int)Math.round((double)this.radius * Math.cos(angle));
                    int z = (int)Math.round((double)this.radius * Math.sin(angle));
                    positions.add(new BlockPos(x, 0, z));
                }
            } else {
                positions = this.calculatePolygonPositions(this.shape.corners(), this.radius, count);
            }
            if (positions.size() > count) {
                positions = positions.subList(0, count);
            }
            Collections.shuffle(entryList);
            for (int i = 0; i < count; ++i) {
                BlockPos offset = (BlockPos)positions.get(i);
                entries.add(((SingleSpreadEntry)entryList.get(i)).copyWithOffset(offset));
            }
        }

        private List<BlockPos> calculatePolygonPositions(int corners, int radius, int count) {
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            BlockPos[] vertices = new BlockPos[corners];
            for (int i = 0; i < corners; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)corners;
                int x = (int)Math.round((double)radius * Math.cos(angle));
                int z = (int)Math.round((double)radius * Math.sin(angle));
                vertices[i] = new BlockPos(x, 0, z);
            }
            if (count < corners) {
                for (int j = 0; j < count; ++j) {
                    int index = (int)Math.floor(((double)j + 0.5) * (double)corners / (double)count);
                    positions.add(vertices[index % corners]);
                }
            } else {
                positions.add(vertices[0]);
                int extra = count - corners;
                int baseExtra = extra / corners;
                int remainder = extra % corners;
                for (int i = 0; i < corners; ++i) {
                    int extraForEdge = baseExtra + (i < remainder ? 1 : 0);
                    this.addEdgePoints(positions, vertices[i], vertices[(i + 1) % corners], extraForEdge);
                    positions.add(vertices[(i + 1) % corners]);
                }
            }
            return positions;
        }

        private void addEdgePoints(List<BlockPos> positions, BlockPos from, BlockPos to, int extraPoints) {
            if (extraPoints <= 0) {
                return;
            }
            for (int i = 1; i <= extraPoints; ++i) {
                double t = (double)i / (double)(extraPoints + 1);
                int x = (int)Math.round((double)from.getX() + t * (double)(to.getX() - from.getX()));
                int z = (int)Math.round((double)from.getZ() + t * (double)(to.getZ() - from.getZ()));
                positions.add(new BlockPos(x, 0, z));
            }
        }

        public static enum Shape {
            CIRCLE(0),
            SQUARE(4),
            HEXAGON(6);

            public static final Codec<Shape> CODEC;
            private final int corners;

            private Shape(int corners) {
                this.corners = corners;
            }

            public int corners() {
                return this.corners;
            }

            static {
                CODEC = SkyCodecs.enumCodec(Shape.class);
            }
        }
    }
}

