/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.config.values;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.block.Block;

public record TemplateSurroundingBlocks(int margin, List<WeightedBlock> blocks) {
    public static final TemplateSurroundingBlocks EMPTY = new TemplateSurroundingBlocks(0, List.of());

    public static TemplateSurroundingBlocks fromJson(JsonObject json) {
        int margin = 1;
        if (json.has("margin")) {
            margin = json.get("margin").getAsInt();
        }
        ArrayList<WeightedBlock> blocks = new ArrayList<WeightedBlock>();
        if (json.has("blocks")) {
            json.getAsJsonArray("blocks").forEach(element -> {
                String blockId;
                ResourceLocation blockLocation;
                JsonObject blocksObject = element.getAsJsonObject();
                int weight = 1;
                if (blocksObject.has("weight")) {
                    weight = blocksObject.get("weight").getAsInt();
                }
                if ((blockLocation = ResourceLocation.tryParse((String)(blockId = blocksObject.get("block").getAsString()))) == null) {
                    throw new IllegalArgumentException("Block id must be a valid resource location");
                }
                Block block = (Block)BuiltInRegistries.BLOCK.get(blockLocation);
                blocks.add(new WeightedBlock(block, weight));
            });
        }
        return new TemplateSurroundingBlocks(margin, blocks);
    }

    public static JsonObject toJson(TemplateSurroundingBlocks surroundingBlocks) {
        JsonObject json = new JsonObject();
        if (surroundingBlocks.margin() != 0) {
            json.addProperty("margin", (Number)surroundingBlocks.margin());
        }
        if (!surroundingBlocks.blocks().isEmpty()) {
            JsonArray blocksArray = new JsonArray();
            surroundingBlocks.blocks().forEach(weightedBlock -> {
                JsonObject blockObject = new JsonObject();
                blockObject.addProperty("block", BuiltInRegistries.BLOCK.getKey((Object)weightedBlock.block).toString());
                blockObject.addProperty("weight", (Number)weightedBlock.weight);
                blocksArray.add((JsonElement)blockObject);
            });
            json.add("blocks", (JsonElement)blocksArray);
        }
        return json;
    }

    public record WeightedBlock(Block block, int weight) implements WeightedEntry
    {
        @Nonnull
        public Weight getWeight() {
            return Weight.of((int)this.weight);
        }
    }
}

