/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.helper;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.util.SkyPaths;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import org.slf4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class InventoryCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"inventory").requires(PermissionManager.INSTANCE::mayExecuteOpCommand)).then(Commands.literal((String)"export").executes(context -> InventoryCommand.exportInventory((CommandSourceStack)context.getSource())));
    }

    private static int exportInventory(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        try {
            Files.createDirectories(SkyPaths.MOD_EXPORTS, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new SimpleCommandExceptionType((Message)SkyComponents.ERROR_CREATING_PATH.apply(SkyPaths.MOD_EXPORTS.toString())).create();
        }
        Path filePath = RandomUtility.getFilePath(SkyPaths.MOD_EXPORTS, "starter_inventory", "json5");
        JsonObject json = new JsonObject();
        json.add("items", (JsonElement)InventoryCommand.vanillaInventory(player));
        if (ModList.get().isLoaded("curios")) {
            json.add("curios_items", (JsonElement)InventoryCommand.curiosInventory(player));
        }
        Path file = SkyPaths.MOD_EXPORTS.resolve(filePath.getFileName());
        try {
            BufferedWriter w = Files.newBufferedWriter(file, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            w.write(SkyblockBuilder.PRETTY_GSON.toJson((JsonElement)json));
            w.close();
        }
        catch (IOException e) {
            throw new SimpleCommandExceptionType((Message)SkyComponents.ERROR_CREATING_FILE.apply(file.toString())).create();
        }
        source.sendSuccess(() -> (Component)SkyComponents.SUCCESS_EXPORT_INVENTORY.apply(filePath.toString()), true);
        return 1;
    }

    private static JsonArray vanillaInventory(ServerPlayer player) {
        RegistryOps registryOps = player.registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        JsonArray items = new JsonArray();
        Inventory inventory = player.getInventory();
        for (ItemStack item : player.getInventory().items) {
            InventoryCommand.addItemWithSlot(items, item, (RegistryOps<JsonElement>)registryOps);
        }
        for (ItemStack item : player.getInventory().offhand) {
            InventoryCommand.addItemWithSlot(items, item, EquipmentSlot.OFFHAND, (RegistryOps<JsonElement>)registryOps);
        }
        for (Object slot : (Object)Inventory.ALL_ARMOR_SLOTS) {
            ItemStack item = (ItemStack)inventory.armor.get((int)slot);
            if (item.isEmpty()) continue;
            EquipmentSlot equipmentSlot = switch (slot) {
                case 0 -> EquipmentSlot.FEET;
                case 1 -> EquipmentSlot.LEGS;
                case 2 -> EquipmentSlot.CHEST;
                case 3 -> EquipmentSlot.HEAD;
                default -> EquipmentSlot.MAINHAND;
            };
            InventoryCommand.addItemWithSlot(items, item, equipmentSlot, (RegistryOps<JsonElement>)registryOps);
        }
        return items;
    }

    private static JsonArray curiosInventory(ServerPlayer player) {
        RegistryOps registryOps = player.registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        JsonArray items = new JsonArray();
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
            Map curios = handler.getCurios();
            for (Map.Entry entry : curios.entrySet()) {
                String identifier = (String)entry.getKey();
                IDynamicStackHandler stacks = ((ICurioStacksHandler)entry.getValue()).getStacks();
                for (int i = 0; i < stacks.getSlots(); ++i) {
                    ItemStack stack = stacks.getStackInSlot(i);
                    InventoryCommand.addItemWithSlot(items, stack, identifier, (RegistryOps<JsonElement>)registryOps);
                }
            }
        });
        return items;
    }

    private static void addItemWithSlot(JsonArray items, ItemStack item, RegistryOps<JsonElement> registryOps) {
        InventoryCommand.addItemWithSlot(items, item, EquipmentSlot.MAINHAND, registryOps);
    }

    private static void addItemWithSlot(JsonArray items, ItemStack item, EquipmentSlot slot, RegistryOps<JsonElement> registryOps) {
        InventoryCommand.addItemWithSlot(items, item, slot.toString().toLowerCase(Locale.ROOT), registryOps);
    }

    private static void addItemWithSlot(JsonArray items, ItemStack item, String slot, RegistryOps<JsonElement> registryOps) {
        if (item.isEmpty()) {
            return;
        }
        Optional optional = ItemStack.OPTIONAL_CODEC.encodeStart(registryOps, (Object)item).resultOrPartial(arg_0 -> ((Logger)SkyblockBuilder.getLogger()).error(arg_0));
        if (optional.isEmpty()) {
            return;
        }
        JsonObject mainObject = new JsonObject();
        mainObject.addProperty("Slot", slot);
        mainObject.add("Item", (JsonElement)optional.get());
        items.add((JsonElement)mainObject);
    }
}

