/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.client.screens.CustomizeSkyblockScreen;
import de.melanx.skyblockbuilder.commands.OpenDumpScreen;
import de.melanx.skyblockbuilder.item.ItemStructureSaver;
import de.melanx.skyblockbuilder.item.StructureSaverSettings;
import de.melanx.skyblockbuilder.registration.ModBlocks;
import de.melanx.skyblockbuilder.registration.ModDataComponentTypes;
import de.melanx.skyblockbuilder.registration.ModItems;
import de.melanx.skyblockbuilder.world.presets.SkyblockPreset;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterPresetEditorsEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.moddingx.libx.render.RenderHelperLevel;

public class ClientEventListener {
    public ClientEventListener() {
        NeoForge.EVENT_BUS.addListener(ClientEventListener::onKeyInput);
        NeoForge.EVENT_BUS.addListener(ClientEventListener::registerClientCommands);
        NeoForge.EVENT_BUS.addListener(ClientEventListener::renderBoundingBox);
    }

    @SubscribeEvent
    public void onRegisterPresetEditors(RegisterPresetEditorsEvent event) {
        event.register(SkyblockPreset.KEY, CustomizeSkyblockScreen::new);
    }

    @SubscribeEvent
    public void buildCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept((ItemLike)ModItems.structureSaver);
            event.accept((ItemLike)ModBlocks.spawnBlock);
        }
    }

    @SubscribeEvent
    public void registerClientExtensions(RegisterClientExtensionsEvent event) {
        ItemProperties.register((Item)ModItems.structureSaver, (ResourceLocation)SkyblockBuilder.getInstance().resource("structure_saver_type"), (stack, level, entity, seed) -> {
            StructureSaverSettings.Type type = (StructureSaverSettings.Type)((Object)((Object)stack.get(ModDataComponentTypes.structureSaverType)));
            return type == null ? 0.0f : (float)type.ordinal();
        });
    }

    private static void registerClientCommands(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"skyblock").then(OpenDumpScreen.register()));
    }

    private static void renderBoundingBox(RenderLevelStageEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !(player.getMainHandItem().getItem() instanceof ItemStructureSaver) || event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        BoundingBox area = ItemStructureSaver.getArea(stack);
        if (area == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        poseStack.pushPose();
        RenderHelperLevel.loadCameraPosition((Camera)event.getCamera(), (PoseStack)poseStack, (double)area.minX(), (double)area.minY(), (double)area.minZ());
        MultiBufferSource.BufferSource source = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer buffer = source.getBuffer((RenderType)RenderType.LINES);
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)buffer, (double)0.0, (double)0.0, (double)0.0, (double)(area.maxX() - area.minX() + 1), (double)(area.maxY() - area.minY() + 1), (double)(area.maxZ() - area.minZ() + 1), (float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
        source.endBatch((RenderType)RenderType.LINES);
        poseStack.popPose();
    }

    private static void onKeyInput(InputEvent.Key event) {
        Direction direction;
        if (event.getAction() != 1) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (!stack.is(ModItems.structureSaver)) {
            return;
        }
        CompoundTag positions = (CompoundTag)stack.get(ModDataComponentTypes.positions);
        if (positions == null || !positions.contains("Position1") || !positions.contains("Position2")) {
            return;
        }
        switch (event.getKey()) {
            case 328: {
                Direction direction2 = player.getDirection();
                break;
            }
            case 322: {
                Direction direction2 = player.getDirection().getOpposite();
                break;
            }
            case 324: {
                Direction direction2 = player.getDirection().getCounterClockWise();
                break;
            }
            case 326: {
                Direction direction2 = player.getDirection().getClockWise();
                break;
            }
            case 329: {
                Direction direction2 = Direction.UP;
                break;
            }
            case 323: {
                Direction direction2 = Direction.DOWN;
                break;
            }
            default: {
                Direction direction2 = direction = null;
            }
        }
        if (direction == null) {
            return;
        }
        Optional pos1 = NbtUtils.readBlockPos((CompoundTag)positions, (String)"Position1");
        Optional pos2 = NbtUtils.readBlockPos((CompoundTag)positions, (String)"Position2");
        if (pos1.isEmpty() || pos2.isEmpty()) {
            return;
        }
        positions.put("Position1", NbtUtils.writeBlockPos((BlockPos)((BlockPos)pos1.get()).relative(direction)));
        positions.put("Position2", NbtUtils.writeBlockPos((BlockPos)((BlockPos)pos2.get()).relative(direction)));
    }
}

