/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.template;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.util.TemplateUtil;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class NetherPortalTemplate {
    private final StructureTemplate structure = new StructureTemplate();
    private final BlockPos portalOffset;

    public NetherPortalTemplate(File file) {
        try {
            this.structure.load((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), TemplateUtil.readTemplate(file.toPath()));
        }
        catch (CommandSyntaxException | IOException e) {
            throw new RuntimeException(e);
        }
        this.portalOffset = NetherPortalTemplate.calcPortalOffset(this.structure);
    }

    private static BlockPos calcPortalOffset(StructureTemplate template) {
        HashSet<StructureTemplate.StructureBlockInfo> netherPortals = new HashSet<StructureTemplate.StructureBlockInfo>();
        for (StructureTemplate.Palette palette : template.palettes) {
            for (StructureTemplate.StructureBlockInfo blockInfo2 : palette.blocks()) {
                if (!blockInfo2.state().is(Blocks.NETHER_PORTAL)) continue;
                netherPortals.add(blockInfo2);
            }
        }
        if (netherPortals.isEmpty()) {
            throw new RuntimeException("There is no nether portal in this template");
        }
        return netherPortals.stream().sorted(Comparator.comparing(blockInfo -> blockInfo.pos().getY())).toList().getFirst().pos();
    }

    public StructureTemplate getStructure() {
        return this.structure;
    }

    public BlockPos getPortalOffset() {
        return this.portalOffset.multiply(-1);
    }
}

