/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.client.GameProfileCache;
import de.melanx.skyblockbuilder.compat.CadmusCompat;
import de.melanx.skyblockbuilder.config.common.InventoryConfig;
import de.melanx.skyblockbuilder.config.common.SpawnConfig;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.data.SkyMeta;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.data.TemplateData;
import de.melanx.skyblockbuilder.template.ConfiguredTemplate;
import de.melanx.skyblockbuilder.template.TemplateInfo;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.util.Spiral;
import de.melanx.skyblockbuilder.util.TemplateUtil;
import de.melanx.skyblockbuilder.util.WorldUtil;
import de.melanx.skyblockbuilder.world.IslandPos;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.fml.ModList;
import org.apache.commons.lang3.tuple.Pair;

public class SkyblockSavedData
extends SavedData {
    public static final String ISLANDS = "islands";
    public static final String ISLAND = "island";
    public static final String META_INFO = "meta_information";
    public static final String PLAYER = "player";
    public static final String META = "meta";
    public static final String SPIRAL_STATE = "spiral_state";
    private static final String NAME = "skyblockbuilder/main";
    private static SkyblockSavedData clientInstance;
    public static final UUID SPAWN_ID;
    private ServerLevel level;
    private ConcurrentMap<UUID, SkyMeta> metaInfo = new ConcurrentHashMap<UUID, SkyMeta>();
    private ConcurrentMap<UUID, Team> skyblocks = new ConcurrentHashMap<UUID, Team>();
    private BiMap<String, UUID> skyblockIds = Maps.synchronizedBiMap((BiMap)HashBiMap.create());
    private BiMap<UUID, IslandPos> skyblockPositions = Maps.synchronizedBiMap((BiMap)HashBiMap.create());
    private Spiral spiral = new Spiral();

    public static SavedData.Factory<SkyblockSavedData> factory() {
        return new SavedData.Factory(SkyblockSavedData::new, (nbt, provider) -> SkyblockSavedData.load(nbt));
    }

    public static SkyblockSavedData get(Level level) {
        if (!level.isClientSide) {
            MinecraftServer server = ((ServerLevel)level).getServer();
            DimensionDataStorage storage = server.overworld().getDataStorage();
            SkyblockSavedData data = (SkyblockSavedData)storage.computeIfAbsent(SkyblockSavedData.factory(), NAME);
            data.level = WorldUtil.getConfiguredLevel(server);
            data.getOrCreateMetaInfo(Util.NIL_UUID);
            return data;
        }
        return clientInstance == null ? new SkyblockSavedData() : clientInstance;
    }

    public static void updateClient(SkyblockSavedData data) {
        clientInstance = data;
    }

    public Team getSpawn() {
        if (this.skyblocks.get(SPAWN_ID) != null) {
            return (Team)this.skyblocks.get(SPAWN_ID);
        }
        SkyblockBuilder.getLogger().info("Successfully generated spawn.");
        Team team = this.createTeam("Spawn", TemplatesConfig.mainSpawnIsland.flatMap(templateInfo -> Optional.of(new ConfiguredTemplate((TemplateInfo)templateInfo))).orElse(TemplateData.get(this.level).getConfiguredTemplate()));
        team.addPlayer(Util.NIL_UUID);
        if (ModList.get().isLoaded("cadmus")) {
            CadmusCompat.protectSpawn(this.level, team);
        }
        this.setDirty();
        return team;
    }

    public Optional<Team> getSpawnOption() {
        return Optional.ofNullable((Team)this.skyblocks.get(SPAWN_ID));
    }

    public Pair<IslandPos, Team> create(String teamName, ConfiguredTemplate template) {
        Team team;
        IslandPos islandPos;
        if (teamName.equalsIgnoreCase("spawn")) {
            pos = new int[]{0, 0};
            if (SpawnConfig.skipCenterIslandCreation) {
                pos = this.spiral.next();
            }
            islandPos = new IslandPos((Level)this.level, pos[0], pos[1], template);
            team = new Team(this, islandPos, SPAWN_ID);
        } else {
            while (this.skyblockPositions.containsValue((Object)(islandPos = new IslandPos((Level)this.level, (pos = this.spiral.next())[0], pos[1], template)))) {
            }
            team = new Team(this, islandPos);
        }
        Set<TemplatesConfig.Spawn> positions = SkyblockSavedData.initialPossibleSpawns(islandPos.getCenter(), template);
        team.setPossibleSpawns(positions);
        team.setName(teamName);
        this.skyblocks.put(team.getId(), team);
        this.skyblockIds.put((Object)team.getName().toLowerCase(Locale.ROOT), (Object)team.getId());
        this.skyblockPositions.put((Object)team.getId(), (Object)islandPos);
        this.setDirty();
        return Pair.of((Object)islandPos, (Object)team);
    }

    public static SkyblockSavedData load(CompoundTag nbt) {
        CompoundTag tag;
        SkyblockSavedData data = new SkyblockSavedData();
        ConcurrentHashMap<UUID, SkyMeta> metaInfo = new ConcurrentHashMap<UUID, SkyMeta>();
        ConcurrentHashMap<UUID, Team> skyblocks = new ConcurrentHashMap<UUID, Team>();
        BiMap skyblockIds = Maps.synchronizedBiMap((BiMap)HashBiMap.create());
        BiMap skyblockPositions = Maps.synchronizedBiMap((BiMap)HashBiMap.create());
        for (Tag inbt : nbt.getList(ISLANDS, 10)) {
            tag = (CompoundTag)inbt;
            IslandPos island = IslandPos.fromTag(tag.getCompound(ISLAND));
            Team team = Team.create(data, tag);
            skyblocks.put(team.getId(), team);
            skyblockIds.put((Object)team.getName().toLowerCase(Locale.ROOT), (Object)team.getId());
            skyblockPositions.put((Object)team.getId(), (Object)island);
        }
        for (Tag inbt : nbt.getList(META_INFO, 10)) {
            tag = (CompoundTag)inbt;
            UUID player = tag.getUUID(PLAYER);
            SkyMeta meta = SkyMeta.get(data, tag.getCompound(META));
            metaInfo.put(player, meta);
        }
        data.metaInfo = metaInfo;
        data.skyblocks = skyblocks;
        data.skyblockIds = skyblockIds;
        data.skyblockPositions = skyblockPositions;
        data.spiral = Spiral.fromArray(nbt.getIntArray(SPIRAL_STATE));
        return data;
    }

    @Nonnull
    public CompoundTag save(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider registries) {
        ListTag islands = new ListTag();
        for (Team team : this.skyblocks.values()) {
            islands.add((Object)team.serializeNBT());
        }
        ListTag metaInfo = new ListTag();
        for (Map.Entry entry : this.metaInfo.entrySet()) {
            SkyMeta meta = (SkyMeta)entry.getValue();
            CompoundTag entryTag = new CompoundTag();
            entryTag.putUUID(PLAYER, (UUID)entry.getKey());
            entryTag.put(META, (Tag)meta.save());
            metaInfo.add((Object)entryTag);
        }
        compound.putIntArray(SPIRAL_STATE, this.spiral.toIntArray());
        compound.put(ISLANDS, (Tag)islands);
        compound.put(META_INFO, (Tag)metaInfo);
        return compound;
    }

    @Nullable
    public IslandPos getTeamIsland(UUID teamId) {
        return (IslandPos)this.skyblockPositions.get((Object)teamId);
    }

    public boolean hasPlayerTeam(Player player) {
        return this.hasPlayerTeam(player.getGameProfile().getId());
    }

    public boolean hasPlayerTeam(UUID player) {
        Team team = this.getTeamFromPlayer(player);
        return team != null && !team.isSpawn();
    }

    public boolean addPlayerToTeam(UUID teamId, Player player) {
        return this.addPlayerToTeam(teamId, player.getGameProfile().getId());
    }

    public boolean addPlayerToTeam(UUID teamId, UUID playerId) {
        Team team = (Team)this.skyblocks.get(teamId);
        if (team != null) {
            return team.addPlayer(playerId);
        }
        return false;
    }

    public boolean addPlayerToTeam(String teamName, Player player) {
        return this.addPlayerToTeam(teamName, player.getGameProfile().getId());
    }

    public boolean addPlayerToTeam(String teamName, UUID player) {
        UUID teamId = (UUID)this.skyblockIds.get((Object)teamName.toLowerCase(Locale.ROOT));
        return this.addPlayerToTeam(teamId, player);
    }

    public boolean addPlayerToTeam(Team team, Player player) {
        return this.addPlayerToTeam(team, player.getGameProfile().getId());
    }

    public boolean addPlayerToTeam(Team team, UUID player) {
        ServerPlayer onlinePlayer;
        ServerLevel level;
        if (!team.isSpawn()) {
            team.broadcast(SkyComponents.EVENT_PLAYER_JOINED.apply(GameProfileCache.getName(player)), Style.EMPTY.applyFormat(ChatFormatting.GOLD));
        }
        if ((level = team.getLevel()) != null && InventoryConfig.initialInventoryType == InventoryConfig.InitialInventoryType.SPAWN == team.isSpawn() && !this.getOrCreateMetaInfo(player).getPreviousTeamIds().contains(team.getId()) && (onlinePlayer = level.getServer().getPlayerList().getPlayer(player)) != null) {
            RandomUtility.setStartInventory(onlinePlayer);
        }
        this.getSpawn().removePlayer(player);
        team.addPlayer(player);
        this.setDirty();
        return true;
    }

    @Nullable
    public Team createTeam(String teamName) {
        if (this.level == null) {
            return null;
        }
        if (teamName.length() > 64) {
            return null;
        }
        return this.createTeam(teamName, TemplateData.get(this.level).getConfiguredTemplate());
    }

    @Nullable
    public Team createTeam(String teamName, ConfiguredTemplate template) {
        if (this.teamExists(teamName) || this.level == null) {
            return null;
        }
        Pair<IslandPos, Team> pair = this.create(teamName, template);
        Team team = (Team)pair.getRight();
        ArrayList<TemplatesConfig.Spawn> possibleSpawns = new ArrayList<TemplatesConfig.Spawn>(this.getPossibleSpawns(team.getIsland(), template));
        team.setPossibleSpawns(possibleSpawns);
        BlockPos center = team.getIsland().getCenter();
        template.placeInWorld(this.level, team, TemplateUtil.STRUCTURE_PLACE_SETTINGS, RandomSource.create(), 2);
        SkyblockSavedData.surround(this.level, center, template);
        this.skyblocks.put(team.getId(), team);
        this.skyblockIds.put((Object)team.getName().toLowerCase(Locale.ROOT), (Object)team.getId());
        this.skyblockPositions.put((Object)team.getId(), (Object)team.getIsland());
        SkyblockBuilder.getLogger().info("Created team {} ({}) at {} with template {}", new Object[]{team.getName(), team.getId(), center, template.getName()});
        this.setDirty();
        return team;
    }

    @Nullable
    public Team createTeamAndJoin(String teamName, Player player) {
        return this.createTeamAndJoin(teamName, player.getGameProfile().getId());
    }

    @Nullable
    public Team createTeamAndJoin(String teamName, UUID player) {
        Team team = this.createTeam(teamName);
        if (team == null) {
            return null;
        }
        team.addPlayer(player);
        this.setDirty();
        return team;
    }

    public boolean removePlayerFromTeam(Player player) {
        return this.removePlayerFromTeam(player.getGameProfile().getId());
    }

    public boolean removePlayerFromTeam(UUID player) {
        for (Map.Entry entry : this.skyblocks.entrySet()) {
            Team team = (Team)entry.getValue();
            if (team.isSpawn() || !team.hasPlayer(player)) continue;
            boolean removed = team.removePlayer(player);
            if (removed) {
                team.broadcast(SkyComponents.EVENT_REMOVE_PLAYER.apply(GameProfileCache.getName(player)), Style.EMPTY.applyFormat(ChatFormatting.RED));
                this.getTeam(SPAWN_ID).addPlayer(player);
                this.getOrCreateMetaInfo(player).setTeamId(SPAWN_ID);
            }
            return removed;
        }
        return false;
    }

    public void removeAllPlayersFromTeam(@Nonnull Team team) {
        HashSet players = Sets.newHashSet(team.getPlayers());
        team.removeAllPlayers();
        Team spawn = this.getSpawn();
        for (UUID player : players) {
            this.addPlayerToTeam(spawn, player);
        }
        this.setDirty();
    }

    @Nullable
    public Team getTeam(String name) {
        return this.getTeam((UUID)this.skyblockIds.get((Object)name.toLowerCase(Locale.ROOT)));
    }

    @Nullable
    public Team getTeam(UUID teamId) {
        return (Team)this.skyblocks.get(teamId);
    }

    public boolean deleteTeam(String team) {
        UUID teamId = (UUID)this.skyblockIds.get((Object)team.toLowerCase(Locale.ROOT));
        return this.deleteTeam(teamId);
    }

    public boolean deleteTeam(UUID teamId) {
        Team removedTeam = (Team)this.skyblocks.remove(teamId);
        if (removedTeam == null) {
            return false;
        }
        this.skyblockIds.inverse().remove((Object)teamId);
        this.skyblockPositions.inverse().remove((Object)removedTeam.getIsland());
        ((Team)this.skyblocks.get(SPAWN_ID)).addPlayers(removedTeam.getPlayers());
        return true;
    }

    @Nullable
    public Team getTeamFromPlayer(Player player) {
        return this.getTeamFromPlayer(player.getGameProfile().getId());
    }

    @Nullable
    public Team getTeamFromPlayer(UUID player) {
        SkyMeta meta = (SkyMeta)this.metaInfo.get(player);
        if (meta == null) {
            return null;
        }
        Team team = this.skyblocks.getOrDefault(meta.getTeamId(), (Team)this.skyblocks.get(SPAWN_ID));
        return team == null || team.isSpawn() ? null : team;
    }

    public boolean teamExists(String name) {
        return this.skyblockIds.containsKey((Object)name.toLowerCase(Locale.ROOT));
    }

    public boolean teamExists(UUID teamId) {
        return this.skyblocks.containsKey(teamId);
    }

    public Collection<Team> getTeams() {
        return this.skyblocks.values();
    }

    public void addInvite(Team team, Player invitor, Player player) {
        this.addInvite(team, invitor, player.getGameProfile().getId());
    }

    public void addInvite(Team team, Player invitor, UUID id) {
        SkyMeta meta = this.getOrCreateMetaInfo(id);
        if (!meta.getInvites().contains(team.getId())) {
            meta.addInvite(team.getId());
            team.broadcast(SkyComponents.EVENT_INVITE_PLAYER.apply(invitor.getDisplayName(), GameProfileCache.getName(id)), Style.EMPTY.applyFormat(ChatFormatting.GOLD));
        }
        this.setDirty();
    }

    public boolean hasInvites(Player player) {
        return this.hasInvites(player.getGameProfile().getId());
    }

    public boolean hasInvites(UUID player) {
        SkyMeta meta = (SkyMeta)this.metaInfo.get(player);
        return meta != null && !meta.getInvites().isEmpty();
    }

    public boolean hasInviteFrom(Team team, Player player) {
        return this.hasInviteFrom(team, player.getGameProfile().getId());
    }

    public boolean hasInviteFrom(Team team, UUID player) {
        SkyMeta meta = (SkyMeta)this.metaInfo.get(player);
        return meta != null && meta.getInvites().contains(team.getId());
    }

    public List<UUID> getInvites(Player player) {
        return this.getInvites(player.getGameProfile().getId());
    }

    public List<UUID> getInvites(UUID player) {
        SkyMeta meta = (SkyMeta)this.metaInfo.get(player);
        return meta == null ? Lists.newArrayList() : meta.getInvites();
    }

    public boolean acceptInvite(Team team, Player player) {
        return this.acceptInvite(team, player.getGameProfile().getId());
    }

    public boolean acceptInvite(Team team, UUID id) {
        SkyMeta meta = (SkyMeta)this.metaInfo.get(id);
        if (meta == null) {
            return false;
        }
        if (meta.getInvites().contains(team.getId())) {
            team.broadcast(SkyComponents.EVENT_ACCEPT_INVITE.apply(GameProfileCache.getName(id)), Style.EMPTY.applyFormat(ChatFormatting.GOLD));
            this.addPlayerToTeam(team.getName(), id);
            meta.resetInvites();
            WorldUtil.teleportToIsland(this.level.getServer().getPlayerList().getPlayer(id), team);
            this.setDirty();
            return true;
        }
        return false;
    }

    public boolean declineInvite(Team team, Player player) {
        return this.declineInvite(team, player.getGameProfile().getId());
    }

    public boolean declineInvite(Team team, UUID id) {
        SkyMeta meta = (SkyMeta)this.metaInfo.get(id);
        if (meta == null) {
            return false;
        }
        meta.removeInvite(team.getId());
        this.setDirty();
        return true;
    }

    public void renameTeam(Team team, @Nullable ServerPlayer player, String name) {
        String oldName = team.getName().toLowerCase();
        this.skyblockIds.remove((Object)oldName);
        team.setName(name);
        this.skyblockIds.put((Object)name.toLowerCase(Locale.ROOT), (Object)team.getId());
        Component playerName = player != null ? player.getDisplayName() : Component.literal((String)"Server");
        team.broadcast((MutableComponent)SkyComponents.EVENT_RENAME_TEAM.apply((Object)playerName, (Object)oldName, (Object)name), Style.EMPTY.applyFormat(ChatFormatting.DARK_RED));
        this.setDirty();
    }

    public SkyMeta getOrCreateMetaInfo(Player player) {
        return this.getOrCreateMetaInfo(player.getGameProfile().getId());
    }

    public SkyMeta getOrCreateMetaInfo(UUID id) {
        return this.metaInfo.computeIfAbsent(id, meta -> new SkyMeta(this, id));
    }

    public Set<TemplatesConfig.Spawn> getPossibleSpawns(IslandPos pos, ConfiguredTemplate template) {
        if (!this.skyblockPositions.containsValue((Object)pos)) {
            return SkyblockSavedData.initialPossibleSpawns(pos.getCenter(), template);
        }
        return ((Team)this.skyblocks.get(this.skyblockPositions.inverse().get((Object)pos))).getPossibleSpawns();
    }

    public static Set<TemplatesConfig.Spawn> initialPossibleSpawns(BlockPos center, ConfiguredTemplate template) {
        HashSet<TemplatesConfig.Spawn> positions = new HashSet<TemplatesConfig.Spawn>();
        for (TemplatesConfig.Spawn spawn : template.getDefaultSpawns()) {
            positions.add(new TemplatesConfig.Spawn(center.offset((Vec3i)spawn.pos().immutable()), spawn.direction()));
        }
        return positions;
    }

    public static void surround(ServerLevel level, BlockPos zero, ConfiguredTemplate configuredTemplate) {
        if (configuredTemplate.getSurroundingBlocks().isEmpty() || configuredTemplate.getSurroundingMargin() <= 0) {
            return;
        }
        StructureTemplate template = configuredTemplate.getTemplate();
        BoundingBox box = new BoundingBox(zero.getX(), zero.getY(), zero.getZ(), zero.getX() + template.size.getX() - 1, zero.getY() + template.size.getY() - 1, zero.getZ() + template.size.getZ() - 1);
        BoundingBox outside = box.inflatedBy(configuredTemplate.getSurroundingMargin());
        RandomSource random = RandomSource.create();
        BlockPos.betweenClosedStream((BoundingBox)outside).forEach(blockPos -> {
            if (!box.isInside((Vec3i)blockPos)) {
                Optional optional = configuredTemplate.getSurroundingBlocks().getRandom(random);
                optional.ifPresent(weightedBlock -> level.setBlock(blockPos, weightedBlock.block().defaultBlockState(), 2));
            }
        });
    }

    public void setDirty() {
        super.setDirty();
        if (this.level != null) {
            SkyblockBuilder.getNetwork().updateData((Level)this.level, this);
            for (ServerPlayer player : this.level.getServer().getPlayerList().getPlayers()) {
                player.refreshTabListName();
            }
        }
    }

    public void setDirtySilently() {
        super.setDirty();
    }

    public void save(@Nonnull File file, @Nonnull HolderLookup.Provider registries) {
        if (this.isDirty()) {
            try {
                Files.createDirectories(file.toPath().getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                SkyblockBuilder.getLogger().error("Could not create directory: {}", (Object)file.getAbsolutePath(), (Object)e);
            }
        }
        super.save(file, registries);
    }

    @Nullable
    public ServerLevel getLevel() {
        return this.level;
    }

    static {
        SPAWN_ID = Util.NIL_UUID;
    }
}

